define("tiny_recordrtc/screen_recorder",["exports","./base_recorder","tiny_recordrtc/modal","tiny_recordrtc/common","core/str"],(function(_exports,_base_recorder,_modal,_common,_str){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_base_recorder=_interopRequireDefault(_base_recorder),_modal=_interopRequireDefault(_modal);class Screen extends _base_recorder.default{configurePlayer(){return this.modalRoot.querySelector("video")}getSupportedTypes(){return["video/webm;codecs=vp9,opus","video/webm;codecs=vp8,opus","video/mp4;codecs=h264,opus","video/mp4;codecs=h264,wav","video/mp4;codecs=v9,opus"]}getRecordingOptions(){return{videoBitsPerSecond:parseInt(this.config.screenbitrate),videoWidth:parseInt(this.config.videoscreenwidth),videoHeight:parseInt(this.config.videoscreenheight)}}getMediaConstraints(){return{audio:!0,systemAudio:"exclude",video:{displaySurface:"monitor",frameRate:{ideal:24},width:{max:parseInt(this.config.videoscreenwidth)},height:{max:parseInt(this.config.videoscreenheight)}}}}playOnCapture(){return!0}getRecordingType(){return"screen"}getTimeLimit(){return this.config.screentimelimit}getEmbedTemplateName(){return"tiny_recordrtc/embed_screen"}getFileName(prefix){return"".concat(prefix,"-video.").concat(this.getFileExtension())}getFileExtension(){return window.MediaRecorder.isTypeSupported("audio/webm")?"webm":window.MediaRecorder.isTypeSupported("audio/mp4")?"mp4":(window.console.warn("Unknown file type for MediaRecorder API"),"")}async captureUserMedia(){const audioPromise=navigator.mediaDevices.getUserMedia({audio:!0}),screenPromise=navigator.mediaDevices.getDisplayMedia(this.getMediaConstraints());await Promise.allSettled([audioPromise,screenPromise]).then(this.combineAudioAndScreenRecording.bind(this))}combineAudioAndScreenRecording(results){const[audioData,screenData]=results;if("fulfilled"!==screenData.status)return void this.handleCaptureFailure(screenData.reason);const screenStream=screenData.value;if(screenStream.getVideoTracks()[0].addEventListener("ended",this.handleStopScreenSharing.bind(this)),"fulfilled"!==audioData.status)return void this.handleCaptureSuccess(screenStream);const audioStream=audioData.value,composedStream=new MediaStream;screenStream.getTracks().forEach((function(track){"video"===track.kind?composedStream.addTrack(track):track.stop()})),audioStream.getAudioTracks().forEach((function(micTrack){composedStream.addTrack(micTrack)})),this.handleCaptureSuccess(composedStream)}handleStopScreenSharing(){this.isRecording()||this.isPaused()?(this.requestRecordingStop(),this.cleanupStream()):(this.setRecordButtonState(!1),this.displayAlert((0,_str.getString)("screensharingstopped_title",_common.component),(0,_str.getString)("screensharingstopped",_common.component)))}handleRecordingStartStopRequested(){this.isRecording()||this.isPaused()?(this.requestRecordingStop(),this.cleanupStream()):this.startRecording()}static getModalClass(){var _class;return _defineProperty(_class=class extends _modal.default{},"TYPE","".concat(_common.component,"/screen_recorder")),_defineProperty(_class,"TEMPLATE","".concat(_common.component,"/screen_recorder")),_class}}return _exports.default=Screen,_exports.default}));

//# sourceMappingURL=screen_recorder.min.js.map