<?php

namespace App\Http\Controllers;

use App\Models\Course;
use App\Models\Department;
use App\Models\Teacher;

use App\Http\Requests\StoreCourseRequest;
use App\Http\Requests\UpdateCourseRequest;

class CourseController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.courses.index')
            ->with('title', 'Courses')
            ->with('courses', Course::all());
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.courses.form')
        ->with('action', 'create')
        ->with('title', 'Create Course')
        ->with('departments', Department::orderBy('name')->get())
        ->with('teachers', Teacher::orderBy('last_name')->get());
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreCourseRequest $request)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        Course::create($request->all());
        return redirect(route('courses.index'))->with('success','Course created successfully!');
    }

    /**
     * Display the specified resource.
     */
    public function show(Course $course)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.courses.show', ['course'=>$course])
            ->with('title', 'View ' . $course->name);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Course $course)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.courses.form')
            ->with('action', 'edit')
            ->with('title', 'Edit ' . $course->name)
            ->with('course', $course)
            ->with('departments', Department::orderBy('name')->get())
            ->with('teachers', Teacher::orderBy('last_name')->get());
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateCourseRequest $request, Course $course)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $course->update($request->all());
        return redirect(route('courses.index'))->with('success','Course ' . $course->name . ' updated successfully!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\School  $course
     * @return \Illuminate\Http\Response
     */
    public function delete(Course $course)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.courses.delete')
            ->with('course', $course)
            ->with('title', 'Delete ' . $course->name);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Course $course)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $course->delete();
        return redirect(route('courses.index'))->with('success','Course ' . $course->name . ' deleted successfully!');
    }
}
