<?php

namespace App\Http\Controllers;

use App\Models\Equipment;
use App\Models\Department;


use App\Http\Requests\StoreEquipmentRequest;
use App\Http\Requests\UpdateEquipmentRequest;

class EquipmentController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.equipment.index')
            ->with('title', 'Equipment')
            ->with('equipment', Equipment::all());
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.equipment.form')
        ->with('action', 'create')
        ->with('title', 'Create Equipment')
        ->with('departments', Department::orderBy('name')->get());
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreEquipmentRequest $request)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        Equipment::create($request->all());
        return redirect(route('equipment.index'))->with('success','Equipment created successfully!');
    }

    /**
     * Display the specified resource.
     */
    public function show(Equipment $equipment)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.equipment.show', ['equipment'=>$equipment])
            ->with('title', 'View ' . $equipment->name);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Equipment $equipment)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.equipment.form')
            ->with('action', 'edit')
            ->with('title', 'Edit ' . $equipment->name)
            ->with('equipment', $equipment)
            ->with('departments', Department::orderBy('name')->get());
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateEquipmentRequest $request, Equipment $equipment)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $equipment->update($request->all());
        return redirect(route('equipment.index'))->with('success','Equipment ' . $equipment->name . ' updated successfully!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\School  $equipment
     * @return \Illuminate\Http\Response
     */
    public function delete(Equipment $equipment)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.equipment.delete')
            ->with('equipment', $equipment)
            ->with('title', 'Delete ' . $equipment->name);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Equipment $equipment)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $equipment->delete();
        return redirect(route('equipment.index'))->with('success','Equipment ' . $equipment->name . ' deleted successfully!');
    }
}
