<?php

namespace App\Http\Controllers;

use App\Models\Position;

use App\Http\Requests\StorePositionRequest;
use App\Http\Requests\UpdatePositionRequest;

class PositionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $positions = Position::all();
        return view('admin.positions.index')
            ->with('title', 'Positions')
            ->with('positions', $positions);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.positions.form')
        ->with('action', 'create')
        ->with('title', 'Create Position');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StorePositionRequest $request)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        Position::create($request->all());
        return redirect(route('positions.index'))->with('success','Position created successfully!');
    }

    /**
     * Display the specified resource.
     */
    public function show(Position $position)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.positions.show', ['position'=>$position])
            ->with('title', 'View ' . $position->name);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Position $position)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.positions.form')
            ->with('action', 'edit')
            ->with('title', 'Edit ' . $position->name)
            ->with('position', $position);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdatePositionRequest $request, Position $position)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $position->update($request->all());
        return redirect(route('positions.index'))->with('success','Position ' . $position->name . ' updated successfully!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\School  $position
     * @return \Illuminate\Http\Response
     */
    public function delete(Position $position)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.positions.delete')
            ->with('position', $position)
            ->with('title', 'Delete ' . $position->name);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Position $position)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $position->delete();
        return redirect(route('positions.index'))->with('success','Position ' . $position->name . ' deleted successfully!');
    }
}
