<?php

namespace App\Http\Controllers;

use App\Models\Teacher;

use App\Http\Requests\StoreTeacherRequest;
use App\Http\Requests\UpdateTeacherRequest;

class TeacherController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $teachers = Teacher::all();
        return view('admin.teachers.index')
            ->with('title', 'Teachers')
            ->with('teachers', $teachers);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.teachers.form')
        ->with('action', 'create')
        ->with('title', 'Create Teacher');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreTeacherRequest $request)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        Teacher::create($request->all());
        return redirect(route('teachers.index'))->with('success','Teacher created successfully!');
    }

    /**
     * Display the specified resource.
     */
    public function show(Teacher $teacher)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.teachers.show', ['teacher'=>$teacher])
            ->with('title', 'View ' . $teacher->first_name . ' ' . $teacher->last_name);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Teacher $teacher)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }

        return view('admin.teachers.form')
            ->with('action', 'edit')
            ->with('title', 'Edit ' . $teacher->first_name . ' ' . $teacher->last_name)
            ->with('teacher', $teacher);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateTeacherRequest $request, Teacher $teacher)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $teacher->update($request->all());
        return redirect(route('teachers.index'))->with('success','Teacher ' . $teacher->first_name . ' '. $teacher->last_name . ' updated successfully!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Teacher  $teacher
     * @return \Illuminate\Http\Response
     */
    public function delete(Teacher $teacher)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.teachers.delete')
            ->with('teacher', $teacher)
            ->with('title', 'Delete ' . $teacher->first_name . ' ' . $teacher->last_name);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Teacher $teacher)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $teacher->delete();
        return redirect(route('teachers.index'))->with('success','Teacher ' . $teacher->first_name . ' '. $teacher->last_name . ' deleted successfully!');
    }
}
