<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\School;

use App\Http\Requests\StoreUserRequest;
use App\Http\Requests\UpdateUserRequest;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        // If the user is an admin (Jason, Lyle, Amy), show all users
        // If the user is school personnel, only show users for that school
        if (auth()->user()->role_id == 1) {
            $users = User::orderby(column: 'name')->get();
        } else {
            return redirect(route('dashboard'))->with('error','You do not have permission to view users.');
        }
        return view('admin.users.index')
            ->with('title', 'Users')
            ->with('users', $users);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        // If the user is an admin (Jason, Lyle, Amy), show all users
        // If the user is school personnel, only show users for that school
  /*      if (auth()->user()->role_id == 1) {
            $schools = School::orderby('name')->get();
        } else {
            $schools = School::where('id', auth()->user()->school_id)->orderby('name')->get();
        }

        return view('admin.users.form')
        ->with('action', 'create')
        ->with('title', 'Create User')
        ->with('schools', $schools); */
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreUserRequest $request)
    {
     /*   User::create($request->all());
        return redirect(route('users.index'))->with('success','User created successfully!'); */
    }

    /**
     * Display the specified resource.
     */
    public function show(User $user)
    {
   /*     return view('admin.users.show', ['user'=>$user])
            ->with('title', 'View ' . $user->first_name . ' ' . $user->last_name); */
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(User $user)
    {
        // If the user is an admin (Jason, Lyle, Amy), show all users
        // If the user is school personnel, only show users for that school
     /*   if (auth()->user()->role_id == 1) {
            $schools = School::orderby('name')->get();
        } else {
            $schools = School::where('id', auth()->user()->school_id)->orderby('name')->get();
        }
        //$courses = Course::orderBy('name')->get();
        return view('admin.users.form')
            ->with('action', 'edit')
            ->with('title', 'Edit ' . $user->first_name . ' ' . $user->last_name)
            ->with('user', $user)
            //->with('courses', $courses)
            ->with('schools', $schools); */
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateUserRequest $request, User $user)
    {
    /*    $user->update($request->all());
        return redirect(route('users.index'))->with('success','User ' . $user->first_name . ' '. $user->last_name . ' updated successfully!'); */
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\School  $user
     * @return \Illuminate\Http\Response
     */
    public function delete(User $user)
    {
  /*      if ($user->enrollments->count() > 0 ) {
            return redirect(route('users.index'))->with('error','Cannot delete user that has enrollments.');
        }
        return view('admin.users.delete')
            ->with('user', $user)
            ->with('title', 'Delete ' . $user->first_name . ' ' . $user->last_name); */
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(User $user)
    {
    /*    $user->delete();
        return redirect(route('users.index'))->with('success','User ' . $user->first_name . ' '. $user->last_name . ' deleted successfully!'); */
    }

    /**
     * Page that uploads a .csv file to bulk upload users
     */
    public function bulkUpload()
    {
      /*  return view('admin.users.bulkupload')
        ->with('action', 'create')
        ->with('title', 'Bulk Upload Users'); */
    }
}
