<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreContactRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'first_name' => 'required',
            'last_name' => 'required',
            'email' => 'required|email',
            'school_id' => 'required|numeric',
            'position_id' => 'required|numeric',
            'is_facilitator' => 'required',
            'phone' => 'nullable|numeric|digits:10',
            'ext' => 'nullable|numeric|digits:5'
        ];
    }
}
