<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreEquipmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|max:100',
            'department_id' => 'required|numeric',
            'description' => 'nullable',
            'model' => 'max:20',
            'serial_num' => 'max:20',
            'purchase_date' => 'required|date',
            'purchase_price' => 'required|numeric',
            'condition' => 'required|max:1',
            'notes' => 'nullable'
        ];
    }
}
