<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreSectionRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'year_id' => 'required|exists:years,id',
            'term' => 'required|in:Y,F,S',
            'course_id' => 'required|exists:courses,id',
            'provider_id' => 'required|exists:providers,id',
            'teacher_id' => 'required|exists:teachers,id',
            'enrollment_max' => 'required|integer|min:0',
            'minimum_grade' => 'required|integer|min:9|max:12',
            'delivery' => 'required|in:O,I,P',
            'dual_credit' => 'required|boolean',
            'is_moodle' => 'required|boolean',
            'moodle_short_name' => 'nullable|string|max:255',
            'is_cancelled' => 'required|boolean',
            'description' => 'required|string',
            'restricted_school_ids' => 'nullable|array',
            'restricted_school_ids.*' => 'integer|exists:schools,id|in:5,6,8', // Restrict to school IDs 5, 6, 8
        ];
    }
}