<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreStudentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'first_name' => 'required',
            'last_name' => 'required',
            'school_id' => 'required|numeric',
            'email' => 'required|email|unique:students',
            'dob' => 'required|date',
            'phone' => 'nullable|numeric|digits:10',
            'grade' => 'required|numeric',
            'gender'=> 'nullable|max:1',
            'ssid' => 'nullable|numeric|unique:students',
            'iep'=> 'required',
            'has_504'=> 'required',
            'notes'=> 'nullable'
        ];
    }
}
