<?php

namespace App\Mail;

use App\Models\Contact;
use Illuminate\Mail\Mailable;

class ContactChanged extends Mailable
{
    public $contact;
    public $action;
    public $sections;
    public $schoolName;

    public function __construct(Contact $contact, string $action, array $sections, string $schoolName)
    {
        $this->contact = $contact;
        $this->action = $action;
        $this->sections = $sections;
        $this->schoolName = $schoolName;
    }

    public function build()
    {
        return $this->subject("Contact {$this->action} Notification")
            ->view('emails.contact_changed')
            ->with([
                'contact' => $this->contact,
                'action' => $this->action,
                'sections' => $this->sections,
                'schoolName' => $this->schoolName,
            ]);
    }
}