<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SchoolEnrollmentReport extends Mailable
{
    use Queueable, SerializesModels;

    public $schoolData;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($schoolData)
    {
        $this->schoolData = $schoolData;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('emails.school-enrollment-report')
                    ->subject('School Enrollment Report for ' . $this->schoolData['name']);
    }
}
