<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasManyThrough;
use Illuminate\Database\Eloquent\Relations\BelongsTo;


class Course extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'term', 'department_id', 'enrollment_max', 'course_code', 'minimum_grade', 'delivery', 'dual_credit', 'description'];

    public function sections(): HasMany {
        return $this->hasMany(Section::class, 'course_id');
    }

    public function enrollments(): HasManyThrough
    {
        return $this->hasManyThrough(Enrollment::class, Section::class);
    }

    public function teacher(): BelongsTo {
        return $this->belongsTo(Teacher::class, 'teacher_id');
    }

    public function department(): BelongsTo {
        return $this->belongsTo(Department::class, 'department_id');
    }

    public function termDesc(){
        if ($this->term === 'Y') {
            return 'Full Year';
        }
        else if($this->term === 'F') {
            return 'Fall';
        }
        else {
            return 'Spring';
        }
    }
}
