<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class WelcomeLetter extends Model
{
    use HasFactory;

    protected $fillable = ['section_id', 'text', 'file1', 'file1_title', 'file2', 'file2_title', 'file3', 'file3_title'];

    public function section(): BelongsTo
    {
        return $this->belongsTo(Section::class);
    }

    public function enrollment(): BelongsTo
    {
        return $this->belongsTo(Enrollment::class);
    }

}
