<?php

namespace App\Traits;
use App\Models\Section;
use App\Models\Contact;
use App\Models\Student;
use App\Traits\ContactPermissionTrait;

trait ContactPermissionTrait
{
    public static function checkContactPermissions($action, $contactId)
    {
        switch ($action) {
            // Anyone but teachers can CRUD a contact. Schools can only create contacts for their school.
            case 'create':
            case 'store':
                if (auth()->user()->role_id == 4) {
                    return false;
                }
                break;
            // Schools can only edit/delete their own contacts. Admin and providers can edit all cotnacts.
            case 'edit':
            case 'update':
            case 'delete':
            case 'drop':
            case 'destroy':
                if (auth()->user()->role_id == 4) {
                    return false;
                }
                else if (auth()->user()->role_id == 3 && auth()->user()->school_id != Contact::find($contactId)->school_id) {
                    return false;
                }
                break;
            // Schools can only see their own contact.
            case 'show':
                switch (auth()->user()->role_id) {
                    case 3:
                        // School Personnel can see enrollments
                        if (auth()->user()->role_id == 3 && auth()->user()->school_id != Contact::find($contactId)->school_id) {
                            return false;
                        }
                        break;
                    default:

                }
                break;
            default:
            // Anyone can see the contact list. However, schools will only list their own contacts
        }
        return true;
    }
}
