<?php

namespace App\Traits;

use App\Models\Student;
use Illuminate\Database\Eloquent\Collection;

trait FetchesStudentsWithoutSSID
{
    /**
     * Get students without SSID or with SSID as 0.
     *
     * @param int|null $schoolId
     * @return Collection
     */
    protected function getStudentsWithoutSSID(?int $schoolId = null): Collection
    {
        return Student::where(function($query) {
                $query->whereNull('ssid')
                      ->orWhere('ssid', '0');
            })
            ->where('grade', '<=', 12)
            ->when($schoolId, function ($query) use ($schoolId) {
                return $query->where('school_id', $schoolId);
            })
            ->orderBy('last_name')
            ->get();
    }
}
