<?php

namespace App\Traits;
use App\Models\Section;
use App\Models\Student;
use App\Traits\SectionPermissionTrait;

trait SectionPermissionTrait
{
    public static function checkSectionPermissions($action)
    {
        switch ($action) {
            // Only admins and providers can CRUD sections
            case 'create':
            case 'store':
            case 'edit':
            case 'update':
            case 'delete':
            case 'drop':
            case 'destroy':
                if (auth()->user()->role_id != 1 && auth()->user()->role_id != 2) {
                    return false;
                }
                break;

            default:
            // Anyone can see the section list or specific section.
        }
        return true;
    }
}
