<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('schools', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100);
            $table->string('mailing_address', 100)->nullable();
            $table->string('mailing_city', 50)->nullable();
            $table->string('mailing_state', 2)->nullable();
            $table->integer('mailing_zip')->nullable();
            $table->integer('mailing_zip4')->nullable();
            $table->string('site_address', 100)->nullable();
            $table->string('site_city', 50)->nullable();
            $table->string('site_state', 2)->nullable();
            $table->integer('site_zip')->nullable();
            $table->string('phone', 10)->nullable();
            $table->integer('ext')->nullable();
            $table->string('fax', 10)->nullable();
            $table->integer('fax_ext')->nullable();
            $table->string('website', 200)->nullable();
            $table->boolean('member_school')->default(true);
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('schools');
    }
};
