<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sections', function (Blueprint $table) {
            $table->integer('minimum_grade')->default(9)->after('enrollment_max');
            $table->boolean('dual_credit')->default(0)->after('minimum_grade');
            $table->text('description')->nullable()->after('dual_credit');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sections', function (Blueprint $table) {
            Schema::dropIfExists('minimum_grade');
            Schema::dropIfExists('dual_credit');
            Schema::dropIfExists('description');
        });
    }
};
