<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up()
    {
        // Step 1: Add a new boolean column
        Schema::table('contacts', function (Blueprint $table) {
            $table->boolean('is_facilitator_bool')->nullable()->after('is_facilitator');
        });

        // Step 2: Copy data from old column to new column
        DB::statement("UPDATE contacts SET is_facilitator_bool = CASE WHEN is_facilitator = 'Y' THEN 1 WHEN is_facilitator = 'N' THEN 0 ELSE NULL END");

        // Step 3: Drop the old column
        Schema::table('contacts', function (Blueprint $table) {
            $table->dropColumn('is_facilitator');
        });

        // Step 4: Rename the new column to the original name
        Schema::table('contacts', function (Blueprint $table) {
            $table->renameColumn('is_facilitator_bool', 'is_facilitator');
        });
    }

    public function down()
    {
        // Reverse the process if needed
        Schema::table('contacts', function (Blueprint $table) {
            $table->string('is_facilitator_string', 1)->nullable()->after('is_facilitator');
        });

        DB::statement("UPDATE contacts SET is_facilitator_string = CASE WHEN is_facilitator = 1 THEN 'Y' WHEN is_facilitator = 0 THEN 'N' ELSE NULL END");

        Schema::table('contacts', function (Blueprint $table) {
            $table->dropColumn('is_facilitator');
        });

        Schema::table('contacts', function (Blueprint $table) {
            $table->renameColumn('is_facilitator_string', 'is_facilitator');
        });
    }
};
