@extends('layouts.cork')
@section('title',  $title)


<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('contacts.index') }}">Contacts</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
        </ol>
    </nav>
</div>
<!-- /BREADCRUMB -->
@endsection

@section('content')
<form method="post" action="@if($action == 'create'){{ route('contacts.store') }} @else {{ route('contacts.update', $contact->id) }} @endif">
    @csrf
    @if($action == 'edit') @method('PUT') @endif
    <div class="form-group">

        <label for="first_name">First Name*</label>
        <div class="form-row">
            <div class="col-md-6 mb-4">
                <input type="text" class="form-control @error('first_name') is-invalid @enderror" name="first_name" id="first_name" aria-describedby="basic-addon3" placeholder="First Name" maxlength="100" @if(isset($contact->first_name)) value="{{ $contact->first_name }}" @else value="{{ old('first_name')}}" @endif>
                @error('first_name')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('first_name') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="last_name">Last Name*</label>
        <div class="form-row">
            <div class="col-md-6 mb-4">
                <input type="text" class="form-control @error('last_name') is-invalid @enderror" name="last_name" id="last_name" aria-describedby="basic-addon3" placeholder="Last Name" maxlength="100" @if(isset($contact->last_name)) value="{{ $contact->last_name }}" @else value="{{ old('last_name')}}" @endif>
                @error('last_name')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('last_name') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="email">Email*</label>
        <div class="form-row">
            <div class="col-md-6 mb-4">
                <input type="text" class="form-control @error('email') is-invalid @enderror" name="email" id="email" aria-describedby="basic-addon3" placeholder="Email" maxlength="50" @if(isset($contact->email)) value="{{ $contact->email }}" @else value="{{ old('email')}}" @endif>
                @error('email')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('email') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="school_id">School*</label>
        <div class="form-row">
            <div class="col-md-6 mb-4">
                <select name="school_id" id="school_id" class="form-select @error('school_id') is-invalid @enderror">
                    @foreach ($schools as $school)
                        <option value="{{ $school->id }}" @if (@isset($contact->school_id) && $school->id === $contact->school_id) selected @endif>{{ $school->name }}</option>
                    @endforeach
                </select>
                @error('school_id')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('school_id') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="position_id">Position*</label>
        <div class="form-row">
            <div class="col-md-6 mb-4">
                <select name="position_id" id="position_id" class="form-select @error('position_id') is-invalid @enderror">
                    @foreach ($positions as $position)
                        <option value="{{ $position->id }}" @if (@isset($contact->position_id) && $position->id === $contact->position_id) selected @endif>{{ $position->position }}</option>
                    @endforeach
                </select>
                @error('position_id')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('position_id') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="is_facilitator">Is Facilitator?*</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <select name="is_facilitator" id="is_facilitator" class="form-select @error('is_facilitator') is-invalid @enderror">
                    <option value="1" @if (@isset($contact->is_facilitator) && 1 === $contact->is_facilitator) selected @endif>Yes</option>
                    <option value="0" @if (@isset($contact->is_facilitator) && 0 === $contact->is_facilitator) selected @endif>No</option>
                </select>
                @error('is_facilitator')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('is_facilitator') }}
                </div>
                @enderror
            </div>
        </div>
        <div class="row">
            <label for="phone">Phone (format: 7015551234)</label>

            <div class="col-md-4 mb-4">
                <input type="text" class="form-control @error('phone') is-invalid @enderror" name="phone" id="phone" aria-describedby="basic-addon3" placeholder="Phone" maxlength="10" @if(isset($contact->phone)) value="{{ $contact->phone }}" @else value="{{ old('phone') }}" @endif>
                @error('phone')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('phone') }}
                </div>
                @enderror
            </div>
            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('ext') is-invalid @enderror" name="ext" id="ext" aria-describedby="basic-addon3" placeholder="Ext" maxlength="5" @if(isset($contact->ext)) value="{{ $contact->ext }}" @else value="{{ old('ext') }}" @endif>
                @error('ext')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('ext') }}
                </div>
                @enderror
            </div>
        </div>

        <div class="form-row">
            <button type="submit" class="mt-4 btn btn-primary">Submit</button>
            <button type="button" class="mt-4 ml-4 btn btn-secondary" onclick="window.history.go(-1); return false;">Cancel</button>
        </div>
    </div>
</form>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')

@endsection
<!--  END PAGE SCRIPTS FILE  -->
