@extends('layouts.cork')
@section('title',  $title)


<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('courses.index') }}">Courses</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
        </ol>
    </nav>
</div>
<!-- /BREADCRUMB -->
@endsection

@section('content')
<form method="post" action="@if($action == 'create'){{ route('courses.store') }} @else {{ route('courses.update', $course->id) }} @endif">
    @csrf
    @if($action == 'edit') @method('PUT') @endif
    <div class="form-group">

        <label for="name">Name*</label>
        <div class="form-row">
            <div class="col-md-6 mb-4">
                <input type="text" class="form-control @error('name') is-invalid @enderror" name="name" id="name" aria-describedby="basic-addon3" placeholder="Course Name" maxlength="100" @if(isset($course->name)) value="{{ $course->name }}" @else value="{{ old('name')}}" @endif>
                @error('name')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('name') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="term">Term*</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <select name="term" id="term" class="form-select @error('term') is-invalid @enderror">
                    <option value="Y" @if (@isset($course->term) && 'Y' === $course->term) selected @endif>Full Year</option>
                    <option value="F" @if (@isset($course->term) && 'F' === $course->term) selected @endif>Fall</option>
                    <option value="S" @if (@isset($course->term) && 'S' === $course->term) selected @endif>Spring</option>
                </select>
                @error('term')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('term') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="department_id">Department*</label>
        <div class="form-row">
            <div class="col-md-4 mb-4">
                <select name="department_id" id="department_id" class="form-select @error('department_id') is-invalid @enderror">
                    @foreach ($departments as $department)
                        <option value="{{ $department->id }}" @if (@isset($course->department_id) && $department->id === $course->department_id) selected @endif>{{ $department->name }}</option>
                    @endforeach
                </select>
                @error('department_id')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('department_id') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="teacher_id">Teacher*</label>
        <div class="form-row">
            <div class="col-md-4 mb-4">
                <select name="teacher_id" id="teacher_id" class="form-select @error('teacher_id') is-invalid @enderror">
                    @foreach ($teachers as $teacher)
                        <option value="{{ $teacher->id }}" @if (@isset($course->teacher_id) && $teacher->id === $course->teacher_id) selected @endif>{{ $teacher->last_name . ', ' . $teacher->first_name }}</option>
                    @endforeach
                </select>
                @error('teacher_id')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('teacher_id') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="enrollment_max">Enrollment Max*</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('enrollment_max') is-invalid @enderror" name="enrollment_max" id="enrollment_max" aria-describedby="basic-addon3" placeholder="Enrollment Max" maxlength="2" @if(isset($course->enrollment_max)) value="{{ $course->enrollment_max }}" @else value="{{ old('enrollment_max')}}" @endif>
                @error('enrollment_max')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('enrollment_max') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="course_code">Course Code</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('course_code') is-invalid @enderror" name="course_code" id="course_code" aria-describedby="basic-addon3" placeholder="Course Code" maxlength="10" @if(isset($course->course_code)) value="{{ $course->course_code }}" @else value="{{ old('course_code')}}" @endif>
                @error('course_code')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('course_code') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="minimum_grade">Minimum Grade*</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <select name="minimum_grade" id="minimum_grade" class="form-select @error('minimum_grade') is-invalid @enderror">
                    <option value="12" @if (@isset($course->minimum_grade) && 12 === $course->minimum_grade) selected @endif>12</option>
                    <option value="11" @if (@isset($course->minimum_grade) && 11 === $course->minimum_grade) selected @endif>11</option>
                    <option value="10" @if (@isset($course->minimum_grade) && 10 === $course->minimum_grade) selected @endif>10</option>
                    <option value="9" @if (@isset($course->minimum_grade) && 9 === $course->minimum_grade) selected @endif>9</option>
                </select>
                @error('minimum_grade')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('minimum_grade') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="delivery">Delivery*</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <select name="delivery" id="delivery" class="form-select @error('delivery') is-invalid @enderror">
                    <option value="I" @if (@isset($course->delivery) && 'I' === $course->delivery) selected @endif>ITV</option>
                    <option value="O" @if (@isset($course->delivery) && 'O' === $course->delivery) selected @endif>Online</option>
                </select>
                @error('delivery')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('delivery') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="dual_credit">Dual Credit*</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <select name="dual_credit" id="dual_credit" class="form-select @error('dual_credit') is-invalid @enderror">
                    <option value="Y" @if (@isset($course->dual_credit) && 'Y' === $course->dual_credit) selected @endif>Yes</option>
                    <option value="N" @if (@isset($course->dual_credit) && 'N' === $course->dual_credit) selected @endif>No</option>
                </select>
                @error('dual_credit')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('dual_credit') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="description">Description*</label>
        <div class="form-row">
            <div class="col-md-12 mb-4">
                <textarea class="form-control" aria-label="With textarea" id="description" name="description" placeholder="Class description...">@if(isset($course->description)) {{ $course->description }} @else {{ old('description')}} @endif</textarea>
                @error('description')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('description') }}
                </div>
                @enderror
            </div>
        </div>

        <div class="form-row">
            <button type="submit" class="mt-4 btn btn-primary">Submit</button>
            <button type="button" class="mt-4 ml-4 btn btn-secondary" onclick="window.history.go(-1); return false;">Cancel</button>
        </div>
    </div>
</form>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')

@endsection
<!--  END PAGE SCRIPTS FILE  -->
