@extends('layouts.cork')
@section('title', $title)

<!-- BEGIN PAGE CSS -->
@section('page-css')
    <link href="/cork/src/plugins/src/apex/apexcharts.css" rel="stylesheet" type="text/css">
    <link href="/cork/src/assets/css/light/components/list-group.css" rel="stylesheet" type="text/css">
    <link href="/cork/src/assets/css/light/dashboard/dash_2.css" rel="stylesheet" type="text/css" />
    <link href="/cork/src/assets/css/dark/components/list-group.css" rel="stylesheet" type="text/css">
    <link href="/cork/src/assets/css/dark/dashboard/dash_2.css" rel="stylesheet" type="text/css" />
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Schools</li>
            </ol>
        </nav>
    </div>
    <!-- /BREADCRUMB -->
@endsection
@section('content')
    <div class="layout-px-spacing">

        <div class="middle-content container-xxl p-0">

            <div class="row layout-top-spacing">

                <div class="col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12 layout-spacing">
                    <div class="widget widget-chart-two">
                        <div class="widget-heading">
                            <h5 class="">Total Enrollments</h5>
                        </div>
                        <div class="widget-content">
                            <div id="total-enrollments" class=""></div>
                        </div>
                    </div>
                </div>
                @if (auth()->user()->role_id == 1 || auth()->user()->role_id == 2)
                    @if ($totalCancelledSectionEnrollments > 0)
                        <div class="col-xl-6 col-lg-12 col-md-12 col-sm-12 col-12 layout-spacing">
                            <div class="widget widget-table-two">

                                <div class="widget-heading">
                                    <h5 class="">Cancelled Section Enrollments (@if ($totalCancelledSectionEnrollments > 4)
                                            4 of
                                        @endif{{ $totalCancelledSectionEnrollments }})</h5>
                                </div>

                                <div class="widget-content">
                                    <div class="table-responsive">
                                        @if ($totalCancelledSectionEnrollments > 0)
                                            <table class="table">
                                                <thead>
                                                    <tr>
                                                        <th>Student</th>
                                                        <th>Enrollment</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($cancelledSectionEnrollments as $c)
                                                        <tr>
                                                            <td>{{ App\Models\Student::find($c->student_id)->last_name }},
                                                                {{ App\Models\Student::find($c->student_id)->first_name }}
                                                            </td>
                                                            <td>{{ App\Models\Course::find(App\Models\Section::find($c->section_id)->course_id)->name }}
                                                            </td>
                                                            <td><a
                                                                    href="{{ route('enrollments.show', App\Models\Enrollment::find($c->id)->id) }}">View</a>
                                                                | <a
                                                                    href="{{ route('enrollments.edit', App\Models\Enrollment::find($c->id)->id) }}">Edit</a>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        @else
                                            <h5><img src="/cork/src/assets/img/green-checkmark.png" width="35"
                                                    height="35" style="text-align: left; padding:5px">Nice! No cancelled
                                                section enrollments!</h5>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                    @if ($waitListEnrollmentsReadyToAdd->count() > 0)
                        <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12 layout-spacing">
                            <div class="widget widget-table-one">
                                <div class="widget-heading">
                                    <h5 class="">Waitlist Enrollments With Open Seats</h5>
                                </div>
                                @foreach ($waitListEnrollmentsReadyToAdd as $w)
                                    @php
                                        if (App\Models\Section::find($w->section_id)->openSeats() <= 0) {
                                            continue;
                                        }
                                    @endphp
                                    <div class="widget-content">
                                        <div class="transactions-list t-info">
                                            <div class="t-item">
                                                <div class="t-company-name">
                                                    <div class="t-icon">
                                                        <div class="avatar">
                                                            <span
                                                                class="avatar-title">{{ substr(App\Models\Student::find($w->student_id)->last_name, 0, 1) }}{{ substr(App\Models\Student::find($w->student_id)->first_name, 0, 1) }}</span>
                                                        </div>
                                                    </div>
                                                    <div class="t-name">
                                                        <h4>
                                                            {{ App\Models\Student::find($w->student_id)->last_name }},
                                                            {{ App\Models\Student::find($w->student_id)->first_name }}</h4>
                                                        <p class="meta-date">
                                                            {{ substr(App\Models\Section::find($w->section_id)->course->name, 0, 35) }}
                                                        </p>
                                                    </div>
                                                </div>
                                                <div class="t-rate rate-inc">
                                                    <p><span><a href="{{ route('enrollments.show', $w->id) }}">View</a> |
                                                            <a
                                                                href="{{ route('enrollments.edit', $w->id) }}">Edit</a></span>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif
                @endif
            </div>

        </div>

    </div>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script>
        var options = {
            series: [
                @foreach ($departments as $d)
                    {{ $d->totalEnrollments }},
                @endforeach
            ],
            labels: [
                @foreach ($departments as $d)
                    '{{ $d->code }}',
                @endforeach
            ],
            chart: {
                type: 'donut',
            },
            colors: [
                @foreach ($departments as $d)
                    '{{ $d->color }}',
                @endforeach
            ],
            plotOptions: {
                pie: {
                    startAngle: 0,
                    endAngle: 360,
                    expandOnClick: true,
                    offsetX: 0,
                    offsetY: 0,
                    customScale: 1,
                    dataLabels: {
                        offset: 0,
                        minAngleToShowLabel: 10
                    },
                    donut: {
                        size: '65%',
                        background: 'transparent',
                        labels: {
                            show: true,
                            name: {
                                show: true,
                                fontSize: '22px',
                                fontFamily: 'Helvetica, Arial, sans-serif',
                                fontWeight: 600,
                                color: undefined,
                                offsetY: -10,
                                formatter: function(val) {
                                    return val
                                }
                            },
                            value: {
                                show: true,
                                fontSize: '16px',
                                fontFamily: 'Helvetica, Arial, sans-serif',
                                fontWeight: 400,
                                color: undefined,
                                offsetY: 16,
                                formatter: function(val) {
                                    return val
                                }
                            },
                            total: {
                                show: true,
                                showAlways: true,
                                label: 'Total',
                                fontSize: '22px',
                                fontFamily: 'Helvetica, Arial, sans-serif',
                                fontWeight: 600,
                                color: '#373d3f',
                                formatter: function(w) {
                                    return w.globals.seriesTotals.reduce((a, b) => {
                                        return a + b
                                    }, 0)
                                }
                            }
                        }
                    },
                }
            },
            responsive: [{
                breakpoint: 480,
                options: {
                    chart: {
                        width: 200
                    },
                    legend: {
                        show: true,
                        position: 'bottom'
                    }
                }
            }]
        };

        var chart = new ApexCharts(document.querySelector("#total-enrollments"), options);
        chart.render();
    </script>
@endsection
<!--  END PAGE SCRIPTS FILE  -->
