@extends('layouts.cork')
@section('title',  $title)


<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('departments.index') }}">Departments</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
        </ol>
    </nav>
</div>
<!-- /BREADCRUMB -->
@endsection

@section('content')
<form method="post" action="@if($action == 'create'){{ route('departments.store') }} @else {{ route('departments.update', $department->id) }} @endif">
    @csrf
    @if($action == 'edit') @method('PUT') @endif
    <div class="form-group">

        <label for="code">Code*</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('code') is-invalid @enderror" name="code" id="code" aria-describedby="basic-addon3" placeholder="Code" maxlength="5" @if(isset($department->code)) value="{{ $department->code }}" @else value="{{ old('code')}}" @endif>
                @error('code')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('code') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="name">Name*</label>
        <div class="form-row">
            <div class="col-md-4 mb-4">
                <input type="text" class="form-control @error('name') is-invalid @enderror" name="name" id="name" aria-describedby="basic-addon3" placeholder="Name" maxlength="50" @if(isset($department->name)) value="{{ $department->name }}" @else value="{{ old('name')}}" @endif>
                @error('name')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('name') }}
                </div>
                @enderror
            </div>
        </div>

        <div class="form-row">
            <button type="submit" class="mt-4 btn btn-primary">Submit</button>
            <button type="button" class="mt-4 ml-4 btn btn-secondary" onclick="window.history.go(-1); return false;">Cancel</button>
        </div>
    </div>
</form>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')

@endsection
<!--  END PAGE SCRIPTS FILE  -->
