@extends('layouts.cork')
@section('title', 'Upload BPS Medical Terminology Students')

@section('page-css')
    <style>
        .form-group { margin-bottom: 1.5rem; }
        .invalid-feedback { display: block !important; }
        .csv-notes ul { list-style-type: disc; margin-left: 20px; }
        .csv-notes li { margin-bottom: 5px; }
    </style>
@endsection

@section('breadcrumb')
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('enrollments.index') }}">Enrollments</a></li>
                <li class="breadcrumb-item active" aria-current="page">Upload BPS Medical Terminology</li>
            </ol>
        </nav>
    </div>
@endsection

@section('content')
    <div class="container">
        @if ($message = Session::get('error'))
            <div class="alert alert-danger alert-dismissible" role="alert">
                <h6 class="alert-heading mb-1"><i class="bx bx-xs bx-store align-top me-2"></i>Error!</h6>
                <span>{{ $message }}</span>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title">CSV File Requirements</h5>
            </div>
            <div class="card-body csv-notes">
                <p>For a successful upload, your <a style="color:blue; text-decoration:underline" href="https://docs.google.com/spreadsheets/d/1KoR0xCcEXMXdOBTIVJK2Dm_0QlK2WRCUh6MA6XTIqTo/edit?usp=sharing" target="_blank">CSV file</a> must contain the following columns with their specific value requirements:</p>
                <ul>
                    <li><strong>`first_name`</strong>: Required. String, maximum 50 characters.</li>
                    <li><strong>`last_name`</strong>: Required. String, maximum 50 characters.</li>
                    <li><strong>`school_id`</strong>: Required. Integer. Must be one of the following values:
                        <ul>
                            <li>`5` (for CHS)</li>
                            <li>`6` (for BHS)</li>
                            <li>`8` (for LHS)</li>
                        </ul>
                    </li>
                    <li><strong>`email`</strong>: Required. Valid email format, maximum 75 characters.</li>
                    <li><strong>`dob`</strong>: Required. Date format (e.g., `YYYY-MM-DD`).</li>
                    <li><strong>`phone`</strong>: Optional. String, maximum 10 characters (digits only).</li>
                    <li><strong>`grade`</strong>: Required. Integer, between 9 and 12.</li>
                    <li><strong>`gender`</strong>: Required. Must be `M` (Male) or `F` (Female).</li>
                    <li><strong>`ssid`</strong>: Required. Integer (Student State ID).</li>
                    <li><strong>`iep`</strong>: Required. Boolean. Use `0` for false, `1` for true.</li>
                    <li><strong>`has_504`</strong>: Required. Boolean. Use `0` for false, `1` for true.</li>
                    <li><strong>`english_learner`</strong>: Required. Boolean. Use `0` for false, `1` for true.</li>
                    <li><strong>`term`</strong>: Required. String. Must be `F` (Fall) or `S` (Spring).</li>
                    <li><strong>`notes`</strong>: Optional. Any text notes.</li>
                </ul>
            </div>
        </div>

        <form action="{{ route('enrollments.bps-medterm-upload-preview') }}" method="POST" enctype="multipart/form-data">
            @csrf
            @foreach ($dropdowns as $label => $sections)
                <div class="form-group">
                    <label for="{{ str_replace(' ', '_', strtolower($label)) }}">{{ $label }}</label>
                    <select name="{{ str_replace(' ', '_', strtolower($label)) }}" id="{{ str_replace(' ', '_', strtolower($label)) }}" class="form-select @error(str_replace(' ', '_', strtolower($label))) is-invalid @enderror">
                        <option value="">-- Select {{ $label }} Section --</option>
                        @if ($sections->isNotEmpty())
                            @foreach ($sections as $id => $name)
                                <option value="{{ $id }}">{{ $name }}</option>
                            @endforeach
                        @else
                            <option value="" disabled>No sections available</option>
                        @endif
                    </select>
                    @error(str_replace(' ', '_', strtolower($label)))
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            @endforeach
            <div class="form-group">
                <label for="csv_file">Upload CSV File</label>
                <input type="file" name="csv_file" id="csv_file" class="form-control @error('csv_file') is-invalid @enderror" accept=".csv,.txt">
                @error('csv_file')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            <button type="submit" class="btn btn-primary">Preview</button>
        </form>
    </div>
@endsection
