@extends('layouts.cork')
@section('title', $title)

<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }
    </style>
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/css/selectize.bootstrap5.min.css"
        integrity="sha512-Ars0BmSwpsUJnWMw+KoUKGKunT7+T8NGK0ORRKj+HT8naZzLSIQoOSIIM3oyaJljgLxFi0xImI5oZkAWEFARSA=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('enrollments.index') }}">Enrollments</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
            </ol>
        </nav>
    </div>
@endsection

@section('content')
    <form method="post"
        action="@if ($action == 'create') {{ route('enrollments.store') }} @else {{ route('enrollments.update', $enrollment->id) }} @endif">
        @csrf
        @if ($action == 'edit')
            @method('PUT')
            <input type="hidden" name="prev_status" id="prev_status" value="{{ $enrollment->status }}" />
        @endif
        <div class="form-group">
            <label for="year_id">School Year*</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <select name="year_id" id="year_id" class="form-select @error('year_id') is-invalid @enderror">
                        @foreach ($years as $year)
                            <option value="{{ $year->id }}" @if (isset($enrollment->year_id) && $year->id === $enrollment->year_id) selected @endif>
                                {{ $year->year }}</option>
                        @endforeach
                    </select>
                    @error('year_id')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('year_id') }}
                        </div>
                    @enderror
                </div>
            </div>
            <label for="provider_id">Provider*</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <select name="provider_id" id="provider_id"
                        class="form-select @error('provider_id') is-invalid @enderror">
                        <option value="0" @if (isset($enrollment->section->provider_id) && 0 === $enrollment->section->provider_id) selected @endif>All</option>
                        @foreach ($providers as $provider)
                            <option value="{{ $provider->id }}" @if (isset($enrollment->section->provider_id) && $provider->id === $enrollment->section->provider_id) selected @endif>
                                {{ $provider->name }}</option>
                        @endforeach
                    </select>
                    @error('provider_id')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('provider_id') }}
                        </div>
                    @enderror
                </div>
            </div>
            <label for="term">Term*</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <select name="term" id="term" class="form-select @error('term') is-invalid @enderror">
                        <option value="A" @if ($term == 'A') selected @endif>All</option>
                        <option value="Y" @if ($term == 'Y') selected @endif>Full Year</option>
                        <option value="F" @if ($term == 'F') selected @endif>Fall</option>
                        <option value="S" @if ($term == 'S') selected @endif>Spring</option>
                    </select>
                    @error('term')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('term') }}
                        </div>
                    @enderror
                </div>
            </div>
            <label for="student_id">Student*</label>
            <div class="form-row">
                <div class="col-md-4 mb-4">
                    <select name="student_id" id="student_id"
                        class="form-select @error('student_id') is-invalid @enderror">
                        @foreach ($students as $student)
                            <option value="{{ $student->id }}" @if (isset($enrollment->student_id) && $student->id === $enrollment->student_id) selected @endif>
                                {{ $student->last_name . ', ' . $student->first_name }}</option>
                        @endforeach
                    </select>
                    @error('student_id')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('student_id') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="section_id">Section*</label>
            <div class="form-row">
                <div class="col-md-8 mb-4" id="test">
                    <select name="section_id" id="section_id" class="form-select @error('section_id') is-invalid @enderror">
                        @foreach ($sections as $section)
                            <option value="{{ $section->id }}" @if (isset($enrollment) && $enrollment->section_id == $section->id) selected @endif>
                                {{ $section->provider->name }} - {{ $section->course->name }} ({{ $section->term == 'F' ? 'Fall' : ($section->term == 'S' ? 'Spring' : 'Full Year') }}) - {{ $section->teacher->last_name }}, {{ $section->teacher->first_name }} - {{ $section->openSeats() }} open seats left
                            </option>
                        @endforeach
                    </select>
                    @error('section_id')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('section_id') }}
                        </div>
                    @enderror
                </div>
            </div>

            @include('admin.enrollments.show-hide-dual-credit')

            @if ($action == 'edit')
                @if (auth()->user()->id == 1)
                    <label for="lms_updated">LMS Updated?*</label>
                    <div class="form-row">
                        <div class="col-md-2 mb-4">
                            <select name="lms_updated" id="lms_updated"
                                class="form-select @error('lms_updated') is-invalid @enderror">
                                <option value="0" @if (isset($enrollment->lms_updated) && 0 === $enrollment->lms_updated) selected @endif>No</option>
                                <option value="1" @if (isset($enrollment->lms_updated) && 1 === $enrollment->lms_updated) selected @endif>Yes</option>
                            </select>
                            @error('lms_updated')
                                <div class="invalid-feedback" style="display: block !important;">
                                    {{ $errors->first('lms_updated') }}
                                </div>
                            @enderror
                        </div>
                    </div>
                @else
                    <input type="hidden" id="lms_updated" name="lms_updated" value="{{ $enrollment->lms_updated }}" />
                @endif
                <label for="status">Status*</label>
                <div class="form-row">
                    <div class="col-md-2 mb-4">
                        <select name="status" id="status" class="form-select @error('status') is-invalid @enderror">
                            <option value="A" @if (isset($enrollment->status) && 'A' === $enrollment->status) selected @endif>Approved</option>
                            <option value="R" @if (isset($enrollment->status) && 'R' === $enrollment->status) selected @endif>Dropped</option>
                            @if (auth()->user()->role_id == 1)
                                <option value="D" @if (isset($enrollment->status) && 'D' === $enrollment->status) selected @endif>Denied</option>
                                <option value="W" @if (isset($enrollment->status) && 'W' === $enrollment->status) selected @endif>Waitlist</option>
                            @endif
                        </select>
                        @error('status')
                            <div class="invalid-feedback" style="display: block !important;">
                                {{ $errors->first('status') }}
                            </div>
                        @enderror
                    </div>
                </div>
                <label for="ps_updated">PowerSchool Updated?*</label>
                <div class="form-row">
                    <div class="col-md-2 mb-4">
                        <select name="ps_updated" id="ps_updated"
                            class="form-select @error('ps_updated') is-invalid @enderror">
                            <option value="0" @if (isset($enrollment->ps_updated) && 0 === $enrollment->ps_updated) selected @endif>No</option>
                            <option value="1" @if (isset($enrollment->ps_updated) && 1 === $enrollment->ps_updated) selected @endif>Yes</option>
                        </select>
                        @error('ps_updated')
                            <div class="invalid-feedback" style="display: block !important;">
                                {{ $errors->first('ps_updated') }}
                            </div>
                        @enderror
                    </div>
                </div>
            @endif
            <div class="form-row">
                <button type="submit" class="mt-4 btn btn-primary">Submit</button>
                <button type="button" class="mt-4 ml-4 btn btn-secondary"
                    onclick="window.history.go(-1); return false;">Cancel</button>
            </div>
        </div>
    </form>
@endsection

<!-- BEGIN PAGE SCRIPTS FILE -->
@section('page-js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/js/selectize.min.js"
        integrity="sha512-IOebNkvA/HZjMM7MxL0NYeLYEalloZ8ckak+NDtOViP7oiYzG5vn6WVXyrJDiJPhl4yRdmNAG49iuLmhkUdVsQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/js/selectize.js"
        integrity="sha512-TCP0r/hsoR3XYFxxMqmxeCZSmHWkjdBiAGy+0xcQ+JU0hOBZMHho7O0x/bXZUf3DH6kcbGhuZFxONYXxMzd7EA=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        $(document).ready(function() {
            $('#student_id').selectize();
            $('#section_id').selectize({
                valueField: 'id',
                labelField: 'name',
                searchField: 'name',
                create: false
            });
            $("#jh").load('/admin/enrollments/show-hide-dual-credit/section/' + ($('#section_id').val() || ''));
        });

        $('#year_id').on('change', function(event) {
            $("#test").load('/admin/sections/sections-by-term/year/' + $('#year_id').val() + '/provider/' + $('#provider_id').val() + '/term/' + $('#term').val(), function() {
                $('#section_id').selectize();
            });
        });

        $('#provider_id').on('change', function(event) {
            $("#test").load('/admin/sections/sections-by-term/year/' + $('#year_id').val() + '/provider/' + $('#provider_id').val() + '/term/' + $('#term').val(), function() {
                $('#section_id').selectize();
            });
        });

        $('#term').on('change', function(event) {
            $("#test").load('/admin/sections/sections-by-term/year/' + $('#year_id').val() + '/provider/' + $('#provider_id').val() + '/term/' + $('#term').val(), function() {
                $('#section_id').selectize();
            });
        });

        $('#section_id').on('change', function(event) {
            $("#jh").load('/admin/enrollments/show-hide-dual-credit/section/' + $('#section_id').val());
        });
    </script>
@endsection