@extends('layouts.cork')
@section('title', $title)

<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }
    </style>
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/src/table/datatable/datatables.css">

    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/light/table/datatable/dt-global_style.css">
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/light/table/datatable/custom_dt_miscellaneous.css">

    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/dark/table/datatable/custom_dt_miscellaneous.css">
    <style>
        .table-responsive {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        #enrollments {
            width: 100% !important;
        }

        #enrollments th,
        #enrollments td {
            white-space: nowrap;
        }

        /* Adjust these widths as needed */
        #enrollments th:nth-child(1),
        #enrollments td:nth-child(1) { width: 100px; }
        #enrollments th:nth-child(2),
        #enrollments td:nth-child(2) { width: 150px; }
        /* ... add more column-specific widths as needed ... */

        @media screen and (max-width: 767px) {
            .table-responsive {
                border: none;
            }
        }
    </style>
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Enrollments</li>
            </ol>
        </nav>
    </div>
    <!-- /BREADCRUMB -->
@endsection
@section('content')
    @if(App\Http\Controllers\EnrollmentController::checkEnrollmentPermissions('create', NULL))
    <div class="form-row">
        <button class="btn btn-primary m-2 " onclick="window.location.href = '{{ route('enrollments.create') }}';">+ Add
            Enrollment</button>
    </div>
    @endif
    <form method="post"
        action="@if ($page == 'index') {{ route('enrollments.filterEnrollments') }} @else {{ route('enrollments.filterWaitListEnrollments') }} @endif">
        @csrf
        <div class="form-row input-group ms-2">
            <div class="col-md-1 mb-4">
                <label for="ps_updated">Year</label>
                <select name="year_id" id="year_id" class="form-select @error('year_id') is-invalid @enderror">
                    @foreach ($years as $year)
                        <option value="{{ $year->id }}" @if (@isset($yearId) && $year->id == $yearId) selected @endif>
                            {{ $year->year }}</option>
                    @endforeach
                </select>
                @error('year_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('year_id') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="school_id">School</label>
                <select name="school_id" id="school_id" class="form-select @error('school_id') is-invalid @enderror">
                    <option value="0" @if (@isset($schoolId) && 0 == $schoolId) selected @endif>-- All --</option>
                    @foreach ($schools as $school)
                        <option value="{{ $school->id }}" @if (@isset($schoolId) && $school->id == $schoolId) selected @endif>
                            {{ $school->name }}</option>
                    @endforeach
                </select>
                @error('school_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('school_id') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="provider_id">Provider</label>
                <select name="provider_id" id="provider_id" class="form-select @error('provider_id') is-invalid @enderror">
                    <option value="0" @if (@isset($providerId) && 0 == $providerId) selected @endif>-- All --</option>
                    @foreach ($providers as $provider)
                        <option value="{{ $provider->id }}" @if (@isset($providerId) && $provider->id == $providerId) selected @endif>
                            {{ $provider->name }}</option>
                    @endforeach
                </select>
                @error('provider_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('provider_id') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="section_id">Section</label>
                <select name="section_id" id="section_id" class="form-select @error('section_id') is-invalid @enderror">
                    <option value="0" @if (@isset($sectionId) && 0 == $sectionId) selected @endif>-- All --</option>
                    @foreach ($sections as $section)
                        <option value="{{ $section->id }}" @if (@isset($sectionId) && $section->id == $sectionId) selected @endif>
                            {{ $section->course->name }} - {{ $section->termDesc() }} -
                            {{ $section->teacher->last_name }}, {{ substr($section->teacher->first_name, 0, 1) }}.
                        </option>
                    @endforeach
                </select>
                @error('section_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('section_id') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="teacher_id">Teacher</label>
                <select name="teacher_id" id="teacher_id" class="form-select @error('teacher_id') is-invalid @enderror">
                    <option value="0" @if (@isset($teacherId) && 0 == $teacherId) selected @endif>-- All --</option>
                    @foreach ($teachers as $t)
                        <option value="{{ $t->id }}" @if (@isset($teacherId) && $t->id == $teacherId) selected @endif>
                            {{ $t->last_name }}, {{ $t->first_name }}
                        </option>
                    @endforeach
                </select>
                @error('teacher_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('teacher_id') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="ps_updated">Status</label>
                <select name="status" id="status" class="form-select @error('status') is-invalid @enderror">
                    @if ($page == 'index')
                        <option value="ALL" @if (@isset($status) && 'ALL' == $status) selected @endif>-- All --</option>
                        <option value="A" @if (@isset($status) && 'A' == $status) selected @endif>Approved</option>
                        <option value="D" @if (@isset($status) && 'D' == $status) selected @endif>Denied</option>
                        <option value="R" @if (@isset($status) && 'R' == $status) selected @endif>Dropped</option>
                    @endif
                    <option value="W" @if (@isset($status) && 'W' == $status) selected @endif>Waitlist</option>
                </select>
                @error('status')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('status') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="term">Term</label>
                <select name="term" id="term" class="form-select @error('term') is-invalid @enderror">
                    <option value="A" @if (@isset($term) && 'A' == $term) selected @endif>-- All --</option>
                    <option value="Y" @if (@isset($term) && 'Y' == $term) selected @endif>Full Year</option>
                    <option value="F" @if (@isset($term) && 'F' == $term) selected @endif>Fall</option>
                    <option value="S" @if (@isset($term) && 'S' == $term) selected @endif>Spring</option>
                </select>
                @error('term')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('term') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="grade">Grade</label>
                <select name="grade" id="grade" class="form-select @error('grade') is-invalid @enderror">
                    <option value="0" @if (@isset($grade) && 0 == $grade) selected @endif>-- All --</option>
                    <option value="12" @if (@isset($grade) && 12 == $grade) selected @endif>12</option>
                    <option value="11" @if (@isset($grade) && 11 == $grade) selected @endif>11</option>
                    <option value="10" @if (@isset($grade) && 10 == $grade) selected @endif>10</option>
                    <option value="9" @if (@isset($grade) && 9 == $grade) selected @endif>9</option>
                </select>
                @error('grade')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('grade') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="dual_credit">Dual Credit</label>
                <select name="dual_credit" id="dual_credit"
                    class="form-select @error('dual_credit') is-invalid @enderror">
                    <option value="ALL" @if (@isset($dualCredit) && 'ALL' == $dualCredit) selected @endif>-- All --</option>
                    <option value="0" @if (@isset($dualCredit) && 0 == $dualCredit) selected @endif>No</option>
                    <option value="1" @if (@isset($dualCredit) && 1 == $dualCredit) selected @endif>Yes</option>
                </select>
                @error('dual_credit')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('dual_credit') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2 mt-2">
                <button type="submit" class="mt-4 btn btn-primary">Apply</button>
            </div>
        </div>
    </form>
    <div class="table-responsive">
        <table id="enrollments" class="table table-hover layout-fixed" style="width:100%">
            <thead>
                <tr>
                    @if ($page == 'waitlist')
                        <th data-priority="1">Date</th>
                    @endif
                    <th data-priority="1">School</th>
                    <th data-priority="1">Course</th>
                    <th data-priority="2">Last Name</th>
                    <th data-priority="2">First Name</th>
                    <th data-priority="3">Email</th>
                    <th data-priority="3">SSID</th>
                    <th data-priority="2">Teacher</th>
                    <th data-priority="3">Provider</th>
                    <th data-priority="3">Term</th>
                    <th data-priority="3">Grade</th>
                    <th data-priority="1">Status</th>
                    <th data-priority="3">Dual Credit</th>
                    <th class="no-content" data-priority="1"></th>
                </tr>
            </thead>
            <tbody>
                @foreach ($enrollments as $e)
                    @php $e = App\Models\Enrollment::find($e->id) @endphp
                    <tr>
                        @if ($page == 'waitlist')
                            <td>
                                @if ($e->section->openSeats() > 0)
                                    <img src="/cork/src/assets/img/important.png" width="15" height="15"
                                        title="Can be added to section" />
                                @endif
                                @if (isset($e->created_at))
                                    {{ $e->created_at }}
                                @endif
                            </td>
                        @endif
                        <td>
                            @if (isset($e->student->school->name))
                                {{ $e->student->school->name }}
                            @endif
                        </td>
                        <td>
                            @if (isset($e->section->course->name))
                                {{ $e->section->course->name }}
                            @endif
                        </td>
                        <td>
                            @if (isset($e->student->last_name))
                                {{ $e->student->last_name }}
                            @endif
                        </td>
                        <td>
                            @if (isset($e->student->first_name))
                                {{ $e->student->first_name }}
                            @endif
                        </td>
                        <td>
                            @if (isset($e->student->email))
                                {{ $e->student->email }}
                            @endif
                        </td>
                        <td>
                            @if (isset($e->student->ssid))
                                {{ $e->student->ssid }}
                            @endif
                        </td>
                        <td>
                            @if (isset($e->section->teacher->last_name))
                                {{ $e->section->teacher->last_name }}, {{ substr($e->section->teacher->first_name, 0, 1) }}.
                            @endif
                        </td>
                        <td>
                            @if (isset($e->section->provider->name))
                                {{ $e->section->provider->name }}
                            @endif
                        </td>
                        <td>
                            @if (isset($e->section->term))
                                {{ $e->section->termDesc() }}
                            @endif
                        </td>
                        <td>
                            @if (isset($e->student->grade))
                                {{ $e->student->grade }}
                            @endif
                        </td>
                        <td>{{ App\Models\Enrollment::find($e->id)->statusDesc() }} </td>
                        <td>
                            @if (isset($e->dual_credit))
                                @if ($e->dual_credit == 1)
                                    Yes
                                @else
                                    No
                                @endif
                            @endif
                        </td>
                        <td>
                            @if ($e->checkEnrollmentPermissions('show', $e->id))
                            <a href="{{ route('enrollments.show', $e->id) }}"><svg xmlns="http://www.w3.org/2000/svg"
                                    height="1em" viewBox="0 0 576 512">
                                    <path
                                        d="M288 32c-80.8 0-145.5 36.8-192.6 80.6C48.6 156 17.3 208 2.5 243.7c-3.3 7.9-3.3 16.7 0 24.6C17.3 304 48.6 356 95.4 399.4C142.5 443.2 207.2 480 288 480s145.5-36.8 192.6-80.6c46.8-43.5 78.1-95.4 93-131.1c3.3-7.9 3.3-16.7 0-24.6c-14.9-35.7-46.2-87.7-93-131.1C433.5 68.8 368.8 32 288 32zM144 256a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-64c0 35.3-28.7 64-64 64c-7.1 0-13.9-1.2-20.3-3.3c-5.5-1.8-11.9 1.6-11.7 7.4c.3 6.9 1.3 13.8 3.2 20.7c13.7 51.2 66.4 81.6 117.6 67.9s81.6-66.4 67.9-117.6c-11.1-41.5-47.8-69.4-88.6-71.1c-5.8-.2-9.2 6.1-7.4 11.7c2.1 6.4 3.3 13.2 3.3 20.3z" />
                                </svg></a>&nbsp;
                            @endif
                            @if ($e->checkEnrollmentPermissions('edit', $e->id))
                            <a href="{{ route('enrollments.edit', $e->id) }}"><svg xmlns="http://www.w3.org/2000/svg"
                                    height="1em" viewBox="0 0 512 512">
                                    <path
                                        d="M362.7 19.3L314.3 67.7 444.3 197.7l48.4-48.4c25-25 25-65.5 0-90.5L453.3 19.3c-25-25-65.5-25-90.5 0zm-71 71L58.6 323.5c-10.4 10.4-18 23.3-22.2 37.4L1 481.2C-1.5 489.7 .8 498.8 7 505s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L421.7 220.3 291.7 90.3z" />
                                </svg></a>&nbsp;
                            @endif
                            @if ($e->checkEnrollmentPermissions('delete', $e->id))
                            <a href="{{ route('enrollments.delete', $e->id) }}"><svg xmlns="http://www.w3.org/2000/svg"
                                    height="1em" viewBox="0 0 448 512">
                                    <path
                                        d="M135.2 17.7L128 32H32C14.3 32 0 46.3 0 64S14.3 96 32 96H416c17.7 0 32-14.3 32-32s-14.3-32-32-32H320l-7.2-14.3C307.4 6.8 296.3 0 284.2 0H163.8c-12.1 0-23.2 6.8-28.6 17.7zM416 128H32L53.2 467c1.6 25.3 22.6 45 47.9 45H346.9c25.3 0 46.3-19.7 47.9-45L416 128z" />
                                </svg></a>
                            @endif
                            @if ($e->checkEnrollmentPermissions('drop', $e->id) && $e->status != 'R')
                                <a href="{{ route('enrollments.drop', $e->id) }}"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" style="fill: rgba(0, 0, 0, 1);transform: ;msFilter:;"><path d="m18.707 12.707-1.414-1.414L13 15.586V6h-2v9.586l-4.293-4.293-1.414 1.414L12 19.414z"></path></svg></a>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    @if ($page == 'waitlist')
                        <th>Date</th>
                    @endif
                    <th>School</th>
                    <th>Course</th>
                    <th>Last Name</th>
                    <th>First Name</th>
                    <th>Email</th>
                    <th>Teacher</th>
                    <th>Provider</th>
                    <th>Term</th>
                    <th>Grade</th>
                    <th>Status</th>
                    <th>Dual Credit</th>
                    <th class="no-content"></th>
                </tr>
            </tfoot>
        </table>
    </div>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')
    <script src="/cork/src/plugins/src/table/datatable/datatables.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/button-ext/dataTables.buttons.min.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/button-ext/jszip.min.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/button-ext/buttons.html5.min.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/button-ext/buttons.print.min.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/custom_miscellaneous.js"></script>

    <script>
        $('#enrollments').DataTable({
            "dom": "<'dt--top-section'<'row'<'col-sm-12 col-md-6 d-flex justify-content-md-start justify-content-center'B><'col-sm-12 col-md-6 d-flex justify-content-md-end justify-content-center mt-md-0 mt-3'f>>>" +
                "<'table-responsive'tr>" +
                "<'dt--bottom-section d-sm-flex justify-content-sm-between text-center'<'dt--pages-count  mb-sm-0 mb-3'i><'dt--pagination'p>>",
            buttons: {
                buttons: [{
                        extend: 'csv',
                        className: 'btn'
                    },
                    {
                        extend: 'excel',
                        className: 'btn'
                    },
                    {
                        extend: 'print',
                        className: 'btn'
                    }
                ]
            },
            "oLanguage": {
                // ... (keep the existing language options)
            },
            "stripeClasses": [],
            "lengthMenu": [25, 50, 75, 100],
            "pageLength": 50,
            "responsive": true,
            "autoWidth": false
        });
    </script>
    <script>
        $('#year_id').on('change', function(event) {
            $("#updatedEnrollmentList").load('/admin/enrollments/enrollment-table/year/' + this.value + '/school/' +
                document.getElementById("school_id").value);
        });
        /* $('#school_id').on('change', function(event) {
            $("#updatedEnrollmentList").load('/admin/enrollments/enrollment-table/year/' + document.getElementById("year_id").value + '/school/' + this.value );
        }); */
    </script>
@endsection
<!--  END PAGE SCRIPTS FILE  -->
