@extends('layouts.cork')
@section('title', $title)

<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }
    </style>
@endsection
<!-- END PAGE CSS -->


<!-- BEGIN BREADCRUMB -->
@section('breadcrumb')
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('enrollments.index') }}">Enrollments</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
            </ol>
        </nav>
    </div>
@endsection
<!-- END BREADCRUMB -->
@section('content')
    <a href="{{ route('students.show', $enrollment->student->id) }}" style="color: blue; text-decoration: underline;">
        {{ $enrollment->student->first_name . ' ' . $enrollment->student->last_name }}
    </a><br />
    <a href="mailto:{{ $enrollment->student->email }}" style="color: blue; text-decoration: underline;">{{ $enrollment->student->email }}</a><br />
    Section: {{ $enrollment->year->year }} {{ $enrollment->section->course->name }}<br />

    @if (isset($enrollment->phone))
        {{ substr($enrollment->phone, 0, 3) }}-{{ substr($enrollment->phone, 3, 3) }}-{{ substr($enrollment->phone, 6, 4) }}
        @endif @if (isset($enrollment->ext))
            Ext: {{ $enrollment->ext }}
        @endif
        <h4 class="mt-2">Teacher Information</h4>
        <p class="mt-1">{{ $enrollment->section->teacher->first_name}} {{ $enrollment->section->teacher->last_name}}<br />
            <a href="mailto:{{ $enrollment->section->teacher->email }}" style="color: blue; text-decoration: underline;">{{ $enrollment->section->teacher->email}}</a><br />
            @if(isset($enrollment->section->teacher->phone)){{ $enrollment->section->teacher->formattedPhone()}} @endif
        </p><br/>
        <p class="mt-2">
            @if (auth()->user()->role_id == 1)
                <button class="btn btn-warning mb-2"
                    onclick="window.location.href = '{{ route('enrollments.edit', $enrollment->id) }}';">Edit
                    Enrollment</button>
                <button class="btn btn-danger mb-2"
                    onclick="window.location.href = '{{ route('enrollments.delete', $enrollment->id) }}';">Delete
                    Enrollment</button>
            @else
                @if ($enrollment->status != 'R')
                    <button class="btn btn-danger mb-2"
                        onclick="window.location.href = '{{ route('enrollments.drop', $enrollment->id) }}';">Drop
                        Enrollment</button>
                @endif
            @endif
        </p>
    @endsection
    <!--  BEGIN PAGE SCRIPTS FILE  -->
    @section('page-js')

    @endsection
    <!--  END PAGE SCRIPTS FILE  -->
