@extends('layouts.cork')
@section('title',  $title)

<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
@endsection
<!-- END PAGE CSS -->


<!-- BEGIN BREADCRUMB -->
@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('equipment.index') }}">Equipment</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
        </ol>
    </nav>
</div>
@endsection
<!-- END BREADCRUMB -->
@section('content')
ID: {{ $equipment->id }} <br/>
Name: {{ $equipment->name }} <br/>
Description: {{ $equipment->description }} <br/>
Serial #: {{ $equipment->serial_num }} <br/>
Department: {{ $equipment->department->name }} <br />
Condition: @if($equipment->condition === 'E') Excellent @elseif($equipment->condition === 'G') Good @elseif($equipment->condition === 'F') Fair @elseif($equipment->condition === 'P') Poor @else Scrap @endif <br/>
Purchase Date: {{ $equipment->purchase_date }} <br/>
Purchase Price: ${{ number_format($equipment->purchase_price, 2) }} <br/>
Notes: {{ $equipment->notes }}<br/>
Checked-Out Status:

<p class="mt-2">
    <button class="btn btn-warning mb-2" onclick="window.location.href = '{{ route("equipment.edit", $equipment->id) }}';">Edit Equipment</button> <button class="btn btn-danger mb-2" onclick="window.location.href = '{{ route("equipment.delete", $equipment->id) }}';">Delete Equipment</button>
</p>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')

@endsection
<!--  END PAGE SCRIPTS FILE  -->
