@if (auth()->user()->role_id == 1 || auth()->user()->role_id == 2)
    <div class="widget widget-table-two">
        <div class="widget-heading">
            <h5 class="">Cancelled Section Enrollments (@if ($totalCancelledSectionEnrollments > 4)
                    4 of
                @endif{{ $totalCancelledSectionEnrollments }})</h5>
        </div>
        <div class="widget-content">
            <div class="table-responsive">
                @if ($totalCancelledSectionEnrollments > 0)
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Student</th>
                                <th>Enrollment</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($cancelledSectionEnrollments as $c)
                                <tr>
                                    <td>{{ $c->student->last_name }}, {{ $c->student->first_name }}</td>
                                    <td>{{ $c->section->course->name }}</td>
                                    <td>
                                        <a href="{{ route('enrollments.show', $c->id) }}">View</a> |
                                        <a href="{{ route('enrollments.edit', $c->id) }}">Edit</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @else
                    <div class="dashboard-card">
                        <h3>
                            <img src="/cork/src/assets/img/green-checkmark.png" class="green-checkmark" alt="Checkmark">
                            0
                        </h3>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endif
