<div class="widget widget-chart-two">
    <div class="widget-heading">
        <h5 class="text-center">Total Approved Enrollments</h5>
    </div>
    <div class="widget-content">
        <div id="enrollments-chart"></div>
        <div class="enrollments-legend">
            @foreach($departments as $department)
                <div class="department-enrollment">
                    <span class="department-color" style="background-color: {{ $department->color }}"></span>
                    <span class="department-code">{{ $department->code }}</span>
                    <span class="department-count">{{ $department->totalEnrollments }}</span>
                </div>
            @endforeach
        </div>
    </div>
</div>

<style>
    .widget-chart-two {
        text-align: center;
    }
    #enrollments-chart {
        margin: 0 auto;
        max-width: 300px;
    }
    .enrollments-legend {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        margin-top: 20px;
    }
    .department-enrollment {
        display: flex;
        align-items: center;
        margin: 5px 10px;
    }
    .department-color {
        width: 15px;
        height: 15px;
        border-radius: 50%;
        margin-right: 5px;
    }
    .department-code {
        margin-right: 5px;
    }
    .department-count {
        font-weight: bold;
    }
</style>

@push('page-scripts')
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    var departments = @json($departments);
    var series = departments.map(d => d.totalEnrollments);
    var labels = departments.map(d => d.code);
    var colors = departments.map(d => d.color);
    var total = series.reduce((a, b) => a + b, 0);

    var options = {
        series: series,
        labels: labels,
        chart: {
            type: 'donut',
            height: 300
        },
        colors: colors,
        plotOptions: {
            pie: {
                donut: {
                    size: '70%',
                    labels: {
                        show: true,
                        total: {
                            show: true,
                            showAlways: true,
                            label: 'Total',
                            fontSize: '22px',
                            fontWeight: 600,
                            color: '#373d3f',
                            formatter: function(w) {
                                return total;
                            }
                        }
                    }
                }
            }
        },
        dataLabels: {
            enabled: false
        },
        legend: {
            show: false
        },
        responsive: [{
            breakpoint: 480,
            options: {
                chart: {
                    height: 250
                }
            }
        }]
    };

    var chart = new ApexCharts(document.querySelector("#enrollments-chart"), options);
    chart.render();
});
</script>
@endpush
