@extends('layouts.cork')
@section('title', $title)

<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }
    </style>
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/src/table/datatable/datatables.css">
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/light/table/datatable/dt-global_style.css">
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/light/table/datatable/custom_dt_miscellaneous.css">
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/dark/table/datatable/custom_dt_miscellaneous.css">
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Enrollments</li>
            </ol>
        </nav>
    </div>
    <!-- /BREADCRUMB -->
@endsection
@section('content')
    <form method="post" action="{{ route('reports.enrollmentsBySectionBySchoolFiltered') }}">
        @csrf
        <div class="form-row input-group ms-2">
            <div class="col-md-1 mb-4">
                <label for="ps_updated">Year</label>
                <select name="year_id" id="year_id" class="form-select @error('year_id') is-invalid @enderror">
                    @foreach ($years as $year)
                        <option value="{{ $year->id }}" @if (@isset($yearId) && $year->id == $yearId) selected @endif>
                            {{ $year->year }}</option>
                    @endforeach
                </select>
                @error('year_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('year_id') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="provider_id">Provider</label>
                <select name="provider_id" id="provider_id" class="form-select @error('provider_id') is-invalid @enderror">
                    <option value="0" @if (@isset($providerId) && 0 == $providerId) selected @endif>-- All --</option>
                    @foreach ($providers as $provider)
                        <option value="{{ $provider->id }}" @if (@isset($providerId) && $provider->id == $providerId) selected @endif>
                            {{ $provider->name }}</option>
                    @endforeach
                </select>
                @error('provider_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('provider_id') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="department_id">Department</label>
                <select name="department_id" id="department_id"
                    class="form-select @error('department_id') is-invalid @enderror">
                    <option value="0" @if (@isset($departmentId) && 0 == $departmentId) selected @endif>-- All --</option>
                    @foreach ($departments as $d)
                        <option value="{{ $d->id }}" @if (@isset($departmentId) && $d->id == $departmentId) selected @endif>
                            {{ $d->name }}</option>
                    @endforeach
                </select>
                @error('department_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('department_id') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="ps_updated">Section</label>
                <select name="section_id" id="section_id" class="form-select @error('section_id') is-invalid @enderror">
                    <option value="0" @if (@isset($sectionId) && 0 == $sectionId) selected @endif>-- All --</option>
                    @foreach ($sections as $section)
                        <option value="{{ $section->id }}" @if (@isset($sectionId) && $section->id == $sectionId) selected @endif>
                            {{ $section->course->name }} - {{ $section->termDesc() }} -
                            {{ $section->teacher->last_name }}, {{ substr($section->teacher->first_name, 0, 1) }}.
                        </option>
                    @endforeach
                </select>
                @error('section_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('section_id') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="term">Term</label>
                <select name="term" id="term" class="form-select @error('term') is-invalid @enderror">
                    <option value="A" @if (@isset($term) && 'A' == $term) selected @endif>-- All --</option>
                    <option value="Y" @if (@isset($term) && 'Y' == $term) selected @endif>Full Year</option>
                    <option value="F" @if (@isset($term) && 'F' == $term) selected @endif>Fall</option>
                    <option value="S" @if (@isset($term) && 'S' == $term) selected @endif>Spring</option>
                </select>
                @error('term')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('term') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="school_id">School</label>
                <select name="school_id" id="school_id" class="form-select @error('school_id') is-invalid @enderror">
                    <option value="0" @if (@isset($schoolId) && 0 == $schoolId) selected @endif>-- All --</option>
                    @foreach ($schools as $school)
                        <option value="{{ $school->id }}" @if (@isset($schoolId) && $school->id == $schoolId) selected @endif>
                            {{ $school->name }}</option>
                    @endforeach
                </select>
                @error('school_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('school_id') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="ps_updated">Status</label>
                <select name="status" id="status" class="form-select @error('status') is-invalid @enderror">
                    <option value="ALL" @if (@isset($status) && 'ALL' == $status) selected @endif>-- All --</option>
                    <option value="A" @if (@isset($status) && 'A' == $status) selected @endif>Approved</option>
                    <option value="D" @if (@isset($status) && 'D' == $status) selected @endif>Denied</option>
                    <option value="R" @if (@isset($status) && 'R' == $status) selected @endif>Dropped</option>
                    <option value="W" @if (@isset($status) && 'W' == $status) selected @endif>Waitlist</option>
                </select>
                @error('status')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('status') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="grade">Grade</label>
                <select name="grade" id="grade" class="form-select @error('grade') is-invalid @enderror">
                    <option value="0" @if (@isset($grade) && 0 == $grade) selected @endif>-- All --</option>
                    <option value="12" @if (@isset($grade) && 12 == $grade) selected @endif>12</option>
                    <option value="11" @if (@isset($grade) && 11 == $grade) selected @endif>11</option>
                    <option value="10" @if (@isset($grade) && 10 == $grade) selected @endif>10</option>
                    <option value="9" @if (@isset($grade) && 9 == $grade) selected @endif>9</option>
                </select>
                @error('grade')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('grade') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2 mt-2">
                <button type="submit" class="mt-4 btn btn-primary">Apply</button>
            </div>
        </div>
    </form>

    <div class="widget-content widget-content-area table-responsive">
        <table id="enrollments" class="table dt-table-hover" style="width:100%">
            <thead>
                <tr>
                    <th>Provider</th>
                    <th>Dept</th>
                    <th>Section</th>
                    <th>Teacher</th>
                    <th>Term</th>
                    <th>Delivery</th>
                    @foreach ($schoolsData as $sch)
                        <th>{{ $sch->name }}</th>
                    @endforeach
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($sectionsData as $sect)
                    <tr>
                        <td>{{ $sect->provider->name }}</td>
                        <td>{{ $sect->course->department->name }}</td>
                        <td>{{ $sect->course->name }}</td>
                        <td>{{ $sect->teacher->last_name }}, {{ $sect->teacher->first_name }}</td>
                        <td>{{ $sect->termDesc() }}</td>
                        <td>
                            @if ($sect->delivery == 'O')
                                Online
                            @else
                                ITV
                            @endif
                        </td>
                        @foreach ($schoolsData as $sch)
                            <td style="align:center">
                                {{ App\Models\Enrollment::enrollmentSQLBuilder($yearId, $sch->id, $providerId, $departmentId, $sect->id, 0, $status, $term, $grade)->count() }}
                            </td>
                        @endforeach
                        <td>{{ App\Models\Enrollment::enrollmentSQLBuilder($yearId, $schoolId, $providerId, $departmentId, $sect->id, 0, $status, $term, $grade)->count() }}
                        </td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    @foreach ($schoolsData as $sch)
                        <th style="align:center">
                            {{ App\Models\Enrollment::enrollmentSQLBuilder($yearId, $sch->id, $providerId, $departmentId, $sectionId, 0, $status, $term, $grade)->count() }}
                        </th>
                    @endforeach
                    <th style="align:center">
                        {{ App\Models\Enrollment::enrollmentSQLBuilder($yearId, $schoolId, $providerId, $departmentId, $sectionId, 0, $status, $term, $grade)->count() }}
                    </th>
                </tr>
                <tr>
                    <th>Provider</th>
                    <th>Dept</th>
                    <th>Section</th>
                    <th>Teacher</th>
                    <th>Term</th>
                    <th>Delivery</th>
                    @foreach ($schoolsData as $sch)
                        <th>{{ $sch->name }}</th>
                    @endforeach
                    <th>Total</th>
                </tr>
            </tfoot>
        </table>
    </div>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')
    <script src="/cork/src/plugins/src/table/datatable/datatables.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/button-ext/dataTables.buttons.min.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/button-ext/jszip.min.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/button-ext/buttons.html5.min.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/button-ext/buttons.print.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#enrollments').DataTable({
                "dom": "<'dt--top-section'<'row'<'col-sm-12 col-md-6 d-flex justify-content-md-start justify-content-center'B><'col-sm-12 col-md-6 d-flex justify-content-md-end justify-content-center mt-md-0 mt-3'f>>>" +
                    "<'table-responsive'tr>" +
                    "<'dt--bottom-section d-sm-flex justify-content-sm-between text-center'<'dt--pages-count  mb-sm-0 mb-3'i><'dt--pagination'p>>",
                buttons: {
                    buttons: [{
                            extend: 'csv',
                            className: 'btn',
                            footer: true
                        },
                        {
                            extend: 'excel',
                            className: 'btn',
                            footer: true
                        },
                        {
                            extend: 'print',
                            className: 'btn',
                            footer: true
                        }
                    ]
                },
                "oLanguage": {
                    "oPaginate": {
                        "sPrevious": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-left"><line x1="19" y1="12" x2="5" y2="12"></line><polyline points="12 19 5 12 12 5"></polyline></svg>',
                        "sNext": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-right"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>'
                    },
                    "sInfo": "Showing page _PAGE_ of _PAGES_",
                    "sSearch": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>',
                    "sSearchPlaceholder": "Search...",
                    "sLengthMenu": "Results :  _MENU_",
                },
                "stripeClasses": [],
                "lengthMenu": [7, 10, 20, 50],
                "pageLength": -1
            });
        });
    </script>
@endsection
<!--  END PAGE SCRIPTS FILE  -->
