@extends('layouts.cork')
@section('title', $title)


<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }
    </style>
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('sections.index') }}">Sections</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
            </ol>
        </nav>
    </div>
    <!-- /BREADCRUMB -->
@endsection

@section('content')
    <form method="post"
        action="@if ($action == 'create') {{ route('sections.store') }} @else {{ route('sections.update', $section->id) }} @endif">
        @csrf
        @if ($action == 'edit')
            @method('PUT')
        @endif
        <div class="form-group">

            <label for="year_id">Year*</label>
            <div class="form-row">
                <div class="col-md-4 mb-4">
                    <select name="year_id" id="year_id" class="form-select @error('year_id') is-invalid @enderror">
                        @foreach ($years as $year)
                            <option value="{{ $year->id }}" @if (@isset($section->year_id) && $year->id === $section->year_id) selected @endif>
                                {{ $year->year }}</option>
                        @endforeach
                    </select>
                    @error('year_id')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('year_id') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="term">Term*</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <select name="term" id="term" class="form-select @error('term') is-invalid @enderror">
                        <option value="Y" @if (@isset($section->term) && 'Y' === $section->term) selected @endif>Full Year</option>
                        <option value="F" @if (@isset($section->term) && 'F' === $section->term) selected @endif>Fall</option>
                        <option value="S" @if (@isset($section->term) && 'S' === $section->term) selected @endif>Spring</option>
                    </select>
                    @error('term')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('term') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="course_id">Course*</label>
            <div class="form-row">
                <div class="col-md-4 mb-4">
                    <select name="course_id" id="course_id" class="form-select @error('course_id') is-invalid @enderror">
                        @foreach ($courses as $course)
                            <option value="{{ $course->id }}" @if (@isset($section->course_id) && $course->id === $section->course_id) selected @endif>
                                {{ $course->name }}</option>
                        @endforeach
                    </select>
                    @error('course_id')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('course_id') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="provider_id">Provider*</label>
            <div class="form-row">
                <div class="col-md-4 mb-4">
                    <select name="provider_id" id="provider_id"
                        class="form-select @error('provider_id') is-invalid @enderror">
                        @foreach ($providers as $provider)
                            <option value="{{ $provider->id }}" @if (@isset($section->provider_id) && $provider->id === $section->provider_id) selected @endif>
                                {{ $provider->name }}</option>
                        @endforeach
                    </select>
                    @error('provider_id')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('provider_id') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="teacher_id">Teacher*</label>
            <div class="form-row">
                <div class="col-md-4 mb-4">
                    <select name="teacher_id" id="teacher_id"
                        class="form-select @error('teacher_id') is-invalid @enderror">
                        @foreach ($teachers as $teacher)
                            <option value="{{ $teacher->id }}" @if (@isset($section->teacher_id) && $teacher->id === $section->teacher_id) selected @endif>
                                {{ $teacher->last_name . ', ' . $teacher->first_name }}</option>
                        @endforeach
                    </select>
                    @error('teacher_id')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('teacher_id') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="enrollment_max">Enrollment Max*</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <input type="text" class="form-control @error('enrollment_max') is-invalid @enderror"
                        name="enrollment_max" id="enrollment_max" aria-describedby="basic-addon3"
                        placeholder="Enrollment Max" maxlength="3"
                        @if (isset($section->enrollment_max)) value="{{ $section->enrollment_max }}" @else value="{{ old('enrollment_max') }}" @endif>
                    @error('enrollment_max')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('enrollment_max') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="minimum_grade">Minimum Grade*</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <select name="minimum_grade" id="minimum_grade"
                        class="form-select @error('minimum_grade') is-invalid @enderror">
                        <option value="12" @if (@isset($section->minimum_grade) && 12 === $section->minimum_grade) selected @endif>12</option>
                        <option value="11" @if (@isset($section->minimum_grade) && 11 === $section->minimum_grade) selected @endif>11</option>
                        <option value="10" @if (@isset($section->minimum_grade) && 10 === $section->minimum_grade) selected @endif>10</option>
                        <option value="9" @if (@isset($section->minimum_grade) && 9 === $section->minimum_grade) selected @endif>9</option>
                    </select>
                    @error('minimum_grade')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('minimum_grade') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="delivery">Delivery*</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <select name="delivery" id="delivery" class="form-select @error('delivery') is-invalid @enderror">
                        <option value="O" @if (@isset($section->delivery) && 'O' === $section->delivery) selected @endif>Online</option>
                        <option value="I" @if (@isset($section->delivery) && 'I' === $section->delivery) selected @endif>ITV</option>
                        <option value="P" @if (@isset($section->delivery) && 'P' === $section->delivery) selected @endif>In-Person</option>
                    </select>
                    @error('delivery')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('delivery') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="dual_credit">Dual Credit*</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <select name="dual_credit" id="dual_credit"
                        class="form-select @error('dual_credit') is-invalid @enderror">
                        <option value="0" @if (@isset($section->dual_credit) && 0 === $section->dual_credit) selected @endif>No</option>
                        <option value="1" @if (@isset($section->dual_credit) && 1 === $section->dual_credit) selected @endif>Yes</option>
                    </select>
                    @error('dual_credit')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('dual_credit') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="is_moodle">Moodle Course?*</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <select name="is_moodle" id="is_moodle"
                        class="form-select @error('is_moodle') is-invalid @enderror">
                        <option value="0" @if (@isset($section->is_moodle) && 0 === $section->is_moodle) selected @endif>No</option>
                        <option value="1" @if (@isset($section->is_moodle) && 1 === $section->is_moodle) selected @endif>Yes</option>
                    </select>
                    @error('is_moodle')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('is_moodle') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="moodle_short_name">Moodle Short Name</label>
            <div class="form-row">
                <div class="col-md-4 mb-4">
                    <input type="text" class="form-control @error('moodle_short_name') is-invalid @enderror"
                        name="moodle_short_name" id="moodle_short_name" aria-describedby="basic-addon3"
                        placeholder="Moodle Short Name"
                        @if (isset($section->moodle_short_name)) value="{{ $section->moodle_short_name }}" @else value="{{ old('moodle_short_name') }}" @endif>
                    @error('moodle_short_name')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('moodle_short_name') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="is_cancelled">Cancelled?*</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <select name="is_cancelled" id="is_cancelled"
                        class="form-select @error('is_cancelled') is-invalid @enderror">
                        <option value="0" @if (@isset($section->is_cancelled) && 0 === $section->is_cancelled) selected @endif>No</option>
                        <option value="1" @if (@isset($section->is_cancelled) && 1 === $section->is_cancelled) selected @endif>Yes</option>
                    </select>
                    @error('is_cancelled')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('is_cancelled') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="restricted_school_ids">Restricted Schools</label>
            <div class="form-row">
                <div class="col-md-4 mb-4">
                    <select name="restricted_school_ids[]" id="restricted_school_ids" multiple
                            class="form-select @error('restricted_school_ids') is-invalid @enderror">
                        <option value="5" @if(isset($section->restricted_school_ids) && in_array(5, $section->restricted_school_ids)) selected @endif>BHS (ID 5)</option>
                        <option value="6" @if(isset($section->restricted_school_ids) && in_array(6, $section->restricted_school_ids)) selected @endif>CHS (ID 6)</option>
                        <option value="8" @if(isset($section->restricted_school_ids) && in_array(8, $section->restricted_school_ids)) selected @endif>LHS (ID 8)</option>
                    </select>
                    <small class="form-text text-muted">Select schools allowed to enroll. Leave empty for no restrictions.</small>
                    @error('restricted_school_ids')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('restricted_school_ids') }}
                        </div>
                    @enderror
                </div>
            </div>
            
            <label for="description">Description*</label>
            <div class="form-row">
                <div class="col-md-12 mb-4">
                    <textarea class="form-control" aria-label="With textarea" id="description" name="description"
                        placeholder="Class description...">
@if (isset($section->description))
{{ $section->description }}
@else
{{ old('description') }}
@endif
</textarea>
                    @error('description')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('description') }}
                        </div>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <button type="submit" class="mt-4 btn btn-primary">Submit</button>
                <button type="button" class="mt-4 ml-4 btn btn-secondary"
                    onclick="window.history.go(-1); return false;">Cancel</button>
            </div>
        </div>
    </form>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')

@endsection
<!--  END PAGE SCRIPTS FILE  -->
