<select name="section_id" id="section_id" class="form-select @error('section_id') is-invalid @enderror">
    @foreach ($sections as $section)
        @php
            $restrictionLabel = '';
            if (
                !empty($section->restricted_school_ids) &&
                (auth()->user()->role_id == 1 || auth()->user()->role_id == 2)
            ) {
                $schoolNames = [];
                if (in_array(5, $section->restricted_school_ids)) {
                    $schoolNames[] = 'BHS';
                }
                if (in_array(6, $section->restricted_school_ids)) {
                    $schoolNames[] = 'CHS';
                }
                if (in_array(8, $section->restricted_school_ids)) {
                    $schoolNames[] = 'LHS';
                }
                $restrictionLabel = ' (' . implode('/', $schoolNames) . ' ONLY)';
            }
        @endphp
        <option value="{{ $section->id }}" @if (isset($section->id) && $section->id == ($section->id ?? $section->id)) selected @endif>
            {{ $section->provider->name }} - {{ $section->course->name }} - {{ $section->teacher->last_name }} -
            {{ $section->termDesc() }} - {{ $section->openSeatsDesc() }}{{ $restrictionLabel }}
        </option>
    @endforeach
</select>
