@extends('layouts.cork')
@section('title', $title)

<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }
    </style>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
@endsection
<!-- END PAGE CSS -->

<!-- BEGIN BREADCRUMB -->
@section('breadcrumb')
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('sections.index') }}">Sections</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
            </ol>
        </nav>
    </div>
@endsection
<!-- END BREADCRUMB -->
@section('content')
    <h6>
        Course: <a href="#">{{ $section->course->name }}</a><br />
        Term: {{ $section->year->year }} {{ $section->termDesc() }}<br />
        Teacher: {{ $section->teacher->last_name . ', ' . $section->teacher->first_name }}<br />
        Enrollments: {{ $section->enrollments->count() }} of {{ $section->enrollment_max }} enrolled<br />
        Delivery: @if ($section->delivery === 'I')
            ITV
        @else
            Online
        @endif
        <br />
        Restricted Schools: 
        @if (!empty($section->restricted_school_ids))
            <span class="badge badge-warning">Restricted</span>
        @endif
        {{ $section->getRestrictedSchoolNames() }}
        <br />
        Description: {{ $section->course->description }}
    </h6>
    @if (auth()->user()->role_id == 1 || auth()->user()->role_id == 2)
        <!-- List Enrollments -->
        @if ($section->enrollments->isEmpty())
            <h4>No Enrollments Found</h4>
        @else
            <h4>{{ $section->enrollments->count() }} Enrollments</h4>
            <div class="table-responsive">
                <table class="table table-bordered table-hover mb-4" id="enrollments-table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>School</th>
                            <th>Status</th>
                            <th>LMS Updated?</th>
                            <th>PS Updated?</th>
                            <th>Dual Credit</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($section->enrollments as $e)
                            <tr>
                                <td>
                                    @if (isset($e->student))
                                        {{ $e->student->last_name . ', ' . $e->student->first_name }}
                                    @endif
                                </td>
                                <td>
                                    @if (isset($e->student))
                                        {{ $e->student->school->name }}
                                    @endif
                                </td>
                                <td>
                                    @if ($e->status === 'A')
                                        Approved
                                    @elseif ($e->status === 'D')
                                        Denied
                                    @elseif ($e->status === 'R')
                                        Dropped
                                    @else
                                        Waitlist
                                    @endif
                                </td>
                                <td>
                                    @if ($e->lms_updated)
                                        Yes
                                    @else
                                        No
                                    @endif
                                </td>
                                <td>
                                    @if ($e->ps_updated)
                                        Yes
                                    @else
                                        No
                                    @endif
                                </td>
                                <td>
                                    @if ($e->dual_credit)
                                        Yes
                                    @else
                                        No
                                    @endif
                                </td>
                                <td><a href="{{ route('enrollments.show', $e->id) }}">View</a> |
                                    <a href="{{ route('enrollments.edit', $e->id) }}">Edit</a> |
                                    <a href="{{ route('enrollments.delete', $e->id) }}">Delete</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif
    @endif
    <p class="mt-2">
        <button class="btn btn-warning mb-2"
            onclick="window.location.href = '{{ route('sections.edit', $section->id) }}';">Edit Section</button> <button
            class="btn btn-danger mb-2"
            onclick="window.location.href = '{{ route('sections.delete', $section->id) }}';">Delete Section</button>
    </p>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#enrollments-table').DataTable({
                "pageLength": 10,
                "lengthMenu": [25, 50, 75, 100],
                "pageLength": 50,
                "language": {
                    "emptyTable": "No enrollments found"
                }
            });
        });
    </script>
@endsection
<!--  END PAGE SCRIPTS FILE  -->