@extends('layouts.cork')
@section('title', $title)


<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }
    </style>
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
    <link href="/cork/src/plugins/src/flatpickr/flatpickr.css" rel="stylesheet" type="text/css">
    <link href="/cork/src/plugins/src/noUiSlider/nouislider.min.css" rel="stylesheet" type="text/css">

    <link href="/cork/src/assets/css/light/scrollspyNav.css" rel="stylesheet" type="text/css" />
    <link href="/cork/src/assets/css/dark/scrollspyNav.css" rel="stylesheet" type="text/css" />
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('students.index') }}">Students</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
            </ol>
        </nav>
    </div>
    <!-- /BREADCRUMB -->
@endsection

@section('content')
    <form method="post"
        action="@if ($action == 'create') {{ route('students.store') }} @else {{ route('students.update', $student->id) }} @endif">
        @csrf
        @if ($action == 'edit')
            @method('PUT')
        @endif
        <div class="form-group">

            <label for="first_name">First Name*</label>
            <div class="form-row">
                <div class="col-md-6 mb-4">
                    <input type="text" class="form-control @error('first_name') is-invalid @enderror" name="first_name"
                        id="first_name" aria-describedby="basic-addon3" placeholder="First Name" maxlength="100"
                        @if (isset($student->first_name)) value="{{ $student->first_name }}" @else value="{{ old('first_name') }}" @endif>
                    @error('first_name')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('first_name') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="last_name">Last Name*</label>
            <div class="form-row">
                <div class="col-md-6 mb-4">
                    <input type="text" class="form-control @error('last_name') is-invalid @enderror" name="last_name"
                        id="last_name" aria-describedby="basic-addon3" placeholder="Last Name" maxlength="100"
                        @if (isset($student->last_name)) value="{{ $student->last_name }}" @else value="{{ old('last_name') }}" @endif>
                    @error('last_name')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('last_name') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="school_id">School*</label>
            <div class="form-row">
                <div class="col-md-3 mb-4">
                    <select name="school_id" id="school_id" class="form-select @error('school_id') is-invalid @enderror">
                        @foreach ($schools as $school)
                            <option value="{{ $school->id }}" @if (@isset($student->school_id) && $school->id === $student->school_id) selected @endif>
                                {{ $school->name }}</option>
                        @endforeach
                    </select>
                    @error('school_id')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('school_id') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="email">Email*</label>
            <div class="form-row">
                <div class="col-md-6 mb-4">
                    <input type="text" class="form-control @error('email') is-invalid @enderror" name="email"
                        id="email" aria-describedby="basic-addon3" placeholder="Email" maxlength="50"
                        @if (isset($student->email)) value="{{ $student->email }}" @else value="{{ old('email') }}" @endif>
                    @error('email')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('email') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="dob">Date of Birth*</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <input type="text" class="form-control @error('dob') is-invalid @enderror" name="dob"
                        id="dob" aria-describedby="basic-addon3" placeholder="DOB" maxlength="10"
                        @if (isset($student->dob)) value="{{ $student->dob }}" @else value="{{ old('dob') }}" @endif>
                    @error('dob')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('dob') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="phone">Phone (format: 7015551234)</label>
            <div class="form-row">
                <div class="col-md-4 mb-4">
                    <input type="text" class="form-control @error('phone') is-invalid @enderror" name="phone"
                        id="phone" aria-describedby="basic-addon3" placeholder="Phone" maxlength="10"
                        @if (isset($student->phone)) value="{{ $student->phone }}" @else value="{{ old('phone') }}" @endif>
                    @error('phone')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('phone') }}
                        </div>
                        <pre>
                </pre>
                    @enderror
                </div>
            </div>

            <label for="grade">Grade* (2025-26)</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <select name="grade" id="grade" class="form-select @error('grade') is-invalid @enderror">
                        <option value="12" @if (@isset($student->grade) && 12 === $student->grade) selected @endif>12</option>
                        <option value="11" @if (@isset($student->grade) && 11 === $student->grade) selected @endif>11</option>
                        <option value="10" @if (@isset($student->grade) && 10 === $student->grade) selected @endif>10</option>
                        <option value="9" @if (@isset($student->grade) && 9 === $student->grade) selected @endif>9</option>
                        <option value="8" @if (@isset($student->grade) && 9 === $student->grade) selected @endif>8</option>
                        <option value="7" @if (@isset($student->grade) && 9 === $student->grade) selected @endif>7</option>
                    </select>
                    @error('grade')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('grade') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="gender">Gender</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <select name="gender" id="gender" class="form-select @error('gender') is-invalid @enderror">
                        <option value="M" @if (@isset($student->gender) && 'M' === $student->gender) selected @endif>Male</option>
                        <option value="F" @if (@isset($student->gender) && 'F' === $student->gender) selected @endif>Female</option>
                    </select>
                    @error('gender')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('gender') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="ssid">State Student ID</label>
            <div class="form-row">
                <div class="col-md-3 mb-4">
                    <input type="text" class="form-control @error('ssid') is-invalid @enderror" name="ssid"
                        id="ssid" aria-describedby="basic-addon3" placeholder="State Student ID" maxlength="10"
                        @if (isset($student->ssid)) value="{{ $student->ssid }}" @else value="{{ old('ssid') }}" @endif>
                    @error('ssid')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('ssid') }}
                        </div>
                    @enderror
                </div>
            </div>


            <label for="iep">Has IEP?*</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <select name="iep" id="iep" class="form-select @error('iep') is-invalid @enderror">
                        <option value="0" @if (@isset($student->iep) && 0 === $student->iep) selected @endif>No</option>
                        <option value="1" @if (@isset($student->iep) && 1 === $student->iep) selected @endif>Yes</option>
                    </select>
                    @error('iep')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('iep') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="has_504">Has 504?*</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <select name="has_504" id="has_504" class="form-select @error('has_504') is-invalid @enderror">
                        <option value="0" @if (@isset($student->has_504) && 0 === $student->has_504) selected @endif>No</option>
                        <option value="1" @if (@isset($student->has_504) && 1 === $student->has_504) selected @endif>Yes</option>
                    </select>
                    @error('has_504')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('has_504') }}
                        </div>
                    @enderror
                </div>
            </div>

            <label for="notes">Notes</label>
            <div class="form-row">
                <div class="col-md-12 mb-4">
                    <textarea class="form-control" aria-label="With textarea" id="notes" name="notes"
                        placeholder="Student notes...">
@if (isset($student->notes))
{{ $student->notes }}
@else
{{ old('notes') }}
@endif
</textarea>
                    @error('notes')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('notes') }}
                        </div>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <button type="submit" class="mt-4 btn btn-primary">Submit</button>
                <button type="button" class="mt-4 ml-4 btn btn-secondary"
                    onclick="window.history.go(-1); return false;">Cancel</button>
            </div>
        </div>
    </form>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')
    <script src="/cork/src/assets/js/scrollspyNav.js"></script>
    <script src="/cork/src/plugins/src/flatpickr/flatpickr.js"></script>
    <script>
        var f1 = flatpickr(document.getElementById('dob'));
    </script>
@endsection
<!--  END PAGE SCRIPTS FILE  -->
