@extends('layouts.cork')
@section('title',  $title)

<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
@endsection
<!-- END PAGE CSS -->


<!-- BEGIN BREADCRUMB -->
@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('teachers.index') }}">Teachers</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
        </ol>
    </nav>
</div>
@endsection
<!-- END BREADCRUMB -->
@section('content')
{{ $teacher->first_name . ' ' . $teacher->last_name }} <br/>
{{ $teacher->email }} <br/>
@if(isset($teacher->phone)){{ substr($teacher->phone, 0,  3) }}-{{ substr($teacher->phone, 3,  3) }}-{{ substr($teacher->phone, 6,  4) }} @endif @if(isset($teacher->ext)) Ext: {{ $teacher->ext }}@endif<br/>
<!-- List Courses -->
@if($teacher->courses->isEmpty())
<h4>No Courses Found</h4>
@else
<div class="accordion" id="accordionExample">
    @foreach($teacher->courses as $course)
    <div class="accordion-item">
        <h2 class="accordion-header">
            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{$course->id}}" aria-expanded="true" aria-controls="collapse{{$course->id}}">
                {{ $course->name }} - @if ($course->term === 'Y') Full Year @elseif($course->term === 'F') Fall @else Spring @endif - {{ $course->enrollments()->get()->count() }} enrollments
            </button>
        </h2>
        <div id="collapse{{$course->id}}" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
            <div class="accordion-body">
                @if($course->enrollments->isEmpty())
                    <h6>No Enrollments Found</h6>
                @else
                    <table class="table table-bordered table-hover mb-4">
                        <thead>
                        <tr>
                            <th>Name</th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($course->enrollments as $enrollment)
                            <tr>
                                <td><a href="{{ route('teachers.show', $enrollment->teacher_id) }}">{{ $enrollment->teacher->last_name . ", "  . $enrollment->teacher->first_name }}</a></td>
                                <td>
                                    <a href="{{ route('enrollments.show', $enrollment->id) }}">View</a> |
                                    <a href="{{ route('enrollments.edit', $enrollment->id) }}">Edit</a> |
                                    <a href="{{ route('enrollments.delete', $enrollment->id) }}">Delete</a>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                @endif
            </div>
        </div>
    </div>
    @endforeach
</div>
@endif

<p class="mt-2">
<button class="btn btn-warning mb-2" onclick="window.location.href = '{{ route("teachers.edit", $teacher->id) }}';">Edit Teacher</button> <button class="btn btn-danger mb-2" onclick="window.location.href = '{{ route("teachers.delete", $teacher->id) }}';">Delete Teacher</button>
</p>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')

@endsection
<!--  END PAGE SCRIPTS FILE  -->
