@extends('layouts.cork')
@section('title',  $title)


<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
    <link href="/cork/src/plugins/src/flatpickr/flatpickr.css" rel="stylesheet" type="text/css">
    <link href="/cork/src/plugins/src/noUiSlider/nouislider.min.css" rel="stylesheet" type="text/css">

    <link href="/cork/src/assets/css/light/scrollspyNav.css" rel="stylesheet" type="text/css" />
    <link href="/cork/src/assets/css/dark/scrollspyNav.css" rel="stylesheet" type="text/css" />
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('years.index') }}">Years</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
        </ol>
    </nav>
</div>
<!-- /BREADCRUMB -->
@endsection

@section('content')
<form method="post" action="@if($action == 'create'){{ route('years.store') }} @else {{ route('years.update', $year->id) }} @endif">
    <input type="hidden" name="year" id="year" @if(isset($year->start_date)) value="{{ $year->start_date }}" @else value="{{ old('start_date')}}" @endif>

    @csrf
    @if($action == 'edit') @method('PUT') @endif
    <div class="form-group">

        <label for="start_date">Start Date</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('start_date') is-invalid @enderror" name="start_date" id="start_date" aria-describedby="basic-addon3" placeholder="Start Date" maxlength="10" @if(isset($year->start_date)) value="{{ $year->start_date }}" @else value="{{ old('start_date')}}" @endif>
                @error('start_date')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('start_date') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="end_date">End Date</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('end_date') is-invalid @enderror" name="end_date" id="end_date" aria-describedby="basic-addon3" placeholder="End Date" maxlength="10" @if(isset($year->end_date)) value="{{ $year->end_date }}" @else value="{{ old('end_date')}}" @endif>
                @error('end_date')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('end_date') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="member_cost">Member Per-Class Cost</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('member_cost') is-invalid @enderror" name="member_cost" id="member_cost" aria-describedby="basic-addon3" placeholder="0.00" maxlength="11" @if(isset($year->member_cost)) value="{{ $year->member_cost }}" @else value="{{ old('member_cost')}}" @endif>
                @error('member_cost')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('member_cost') }}
                </div>
                @enderror
            </div>
        </div>


        <label for="non_member_cost">Non-Member Per-Class Cost</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('non_member_cost') is-invalid @enderror" name="non_member_cost" id="non_member_cost" aria-describedby="basic-addon3" placeholder="0.00" maxlength="11" @if(isset($year->non_member_cost)) value="{{ $year->non_member_cost }}" @else value="{{ old('non_member_cost')}}" @endif>
                @error('non_member_cost')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('non_member_cost') }}
                </div>
                @enderror
            </div>
        </div>

        <div class="form-row">
            <button type="submit" class="mt-4 btn btn-primary">Submit</button>
            <button type="button" class="mt-4 ml-4 btn btn-secondary" onclick="window.history.go(-1); return false;">Cancel</button>
        </div>
    </div>
</form>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')
<script src="/cork/src/assets/js/scrollspyNav.js"></script>
<script src="/cork/src/plugins/src/flatpickr/flatpickr.js"></script>
<script>
    var f1 = flatpickr(document.getElementById('start_date'));
    var f2 = flatpickr(document.getElementById('end_date'));
</script>
@endsection
<!--  END PAGE SCRIPTS FILE  -->


