@extends('layouts.cork')
@section('title',  $title)

<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
@endsection
<!-- END PAGE CSS -->


<!-- BEGIN BREADCRUMB -->
@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('years.index') }}">Years</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
        </ol>
    </nav>
</div>
@endsection
<!-- END BREADCRUMB -->
@section('content')
{{ $year->year }} <br/>
Year Dates: {{ $year->start_date }} - {{ $year->end_date }} <br/>
Member Cost: ${{ number_format($year->member_cost,2) }}<br/>
Non-Member Cost: ${{ number_format($year->non_member_cost,2) }}

<p class="mt-2">
<button class="btn btn-warning mb-2" onclick="window.location.href = '{{ route("years.edit", $year->id) }}';">Edit Year</button> <button class="btn btn-danger mb-2" onclick="window.location.href = '{{ route("years.delete", $year->id) }}';">Delete Year</button>
</p>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')

@endsection
<!--  END PAGE SCRIPTS FILE  -->
