<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>School Enrollment Report</title>
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
    <h1>School Enrollment Report for {{ $schoolData['name'] }}</h1>

    <p><strong>Total Approved Enrollments: {{ count($schoolData['enrollments']) }}</strong></p>

    @if(count($schoolData['enrollments']) > 0)
        <table>
            <thead>
                <tr>
                    <th>Last Name</th>
                    <th>First Name</th>
                    <th>Section</th>
                    <th>Teacher</th>
                </tr>
            </thead>
            <tbody>
                @foreach($schoolData['enrollments'] as $enrollment)
                    <tr>
                        <td>{{ $enrollment['last_name'] }}</td>
                        <td>{{ $enrollment['first_name'] }}</td>
                        <td>{{ $enrollment['section'] }}</td>
                        <td>{{ $enrollment['teacher'] }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <p>No approved enrollments for this school.</p>
    @endif
</body>
</html>
