<?php $__env->startSection('title',  $title); ?>

<!-- BEGIN PAGE CSS -->
<?php $__env->startSection('page-css'); ?>
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
<?php $__env->stopSection(); ?>
<!-- END PAGE CSS -->


<!-- BEGIN BREADCRUMB -->
<?php $__env->startSection('breadcrumb'); ?>
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('courses.index')); ?>">Courses</a></li>
            <li class="breadcrumb-item active" aria-current="page"><?php echo e($title); ?></li>
        </ol>
    </nav>
</div>
<?php $__env->stopSection(); ?>
<!-- END BREADCRUMB -->
<?php $__env->startSection('content'); ?>
    Code: <?php echo e($department->code); ?> <br/>
    Name: <?php echo e($department->name); ?>

<p class="mt-2">
<button class="btn btn-warning mb-2" onclick="window.location.href = '<?php echo e(route("departments.edit", $department->id)); ?>';">Edit Department</button> <button class="btn btn-danger mb-2" onclick="window.location.href = '<?php echo e(route("departments.delete", $department->id)); ?>';">Delete Department</button>
</p>
<!-- List Courses -->
<?php if($department->courses->isEmpty()): ?>
    <h4>No Courses Found</h4>
<?php else: ?>
    <div class="accordion" id="accordionExample">
        <?php $__currentLoopData = $department->courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="accordion-item">
            <h2 class="accordion-header">
                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo e($course->id); ?>" aria-expanded="true" aria-controls="collapse<?php echo e($course->id); ?>">
                    <?php echo e($course->name); ?> - <?php if($course->term === 'Y'): ?> Full Year <?php elseif($course->term === 'F'): ?> Fall <?php else: ?> Spring <?php endif; ?> - <?php echo e($course->enrollments()->get()->count()); ?> enrollments
                </button>
            </h2>
            <div id="collapse<?php echo e($course->id); ?>" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                <div class="accordion-body">
                    <?php if($course->enrollments->isEmpty()): ?>
                        <h6>No Enrollments Found</h6>
                    <?php else: ?>
                        <table class="table table-bordered table-hover mb-4">
                            <thead>
                            <tr>
                                <th>Name</th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $course->enrollments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enrollment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><a href="<?php echo e(route('students.show', $enrollment->student_id)); ?>"><?php echo e($enrollment->student->last_name . ", "  . $enrollment->student->first_name); ?></a></td>
                                    <td>
                                        <a href="<?php echo e(route('enrollments.show', $enrollment->id)); ?>">View</a> |
                                        <a href="<?php echo e(route('enrollments.edit', $enrollment->id)); ?>">Edit</a> |
                                        <a href="<?php echo e(route('enrollments.delete', $enrollment->id)); ?>">Delete</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<!--  BEGIN PAGE SCRIPTS FILE  -->
<?php $__env->startSection('page-js'); ?>

<?php $__env->stopSection(); ?>
<!--  END PAGE SCRIPTS FILE  -->

<?php echo $__env->make('layouts.cork', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\jason_horner\Dropbox\laravel\10\registration\resources\views/admin/departments/show.blade.php ENDPATH**/ ?>