<?php $__env->startSection('title', $title); ?>

<!-- BEGIN PAGE CSS -->
<?php $__env->startSection('page-css'); ?>
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }
    </style>
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/css/selectize.bootstrap5.min.css"
        integrity="sha512-Ars0BmSwpsUJnWMw+KoUKGKunT7+T8NGK0ORRKj+HT8naZzLSIQoOSIIM3oyaJljgLxFi0xImI5oZkAWEFARSA=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
<?php $__env->stopSection(); ?>
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
<?php $__env->startSection('breadcrumb'); ?>
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('enrollments.index')); ?>">Enrollments</a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e($title); ?></li>
            </ol>
        </nav>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <form method="post"
        action="<?php if($action == 'create'): ?> <?php echo e(route('enrollments.store')); ?> <?php else: ?> <?php echo e(route('enrollments.update', $enrollment->id)); ?> <?php endif; ?>">
        <?php echo csrf_field(); ?>
        <?php if($action == 'edit'): ?>
            <?php echo method_field('PUT'); ?>
            <input type="hidden" name="prev_status" id="prev_status" value="<?php echo e($enrollment->status); ?>" />
        <?php endif; ?>
        <div class="form-group">
            <label for="year_id">School Year*</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <select name="year_id" id="year_id" class="form-select <?php $__errorArgs = ['year_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($year->id); ?>" <?php if(isset($enrollment->year_id) && $year->id === $enrollment->year_id): ?> selected <?php endif; ?>>
                                <?php echo e($year->year); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['year_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback" style="display: block !important;">
                            <?php echo e($errors->first('year_id')); ?>

                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            <label for="provider_id">Provider*</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <select name="provider_id" id="provider_id"
                        class="form-select <?php $__errorArgs = ['provider_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <option value="0" <?php if(isset($enrollment->section->provider_id) && 0 === $enrollment->section->provider_id): ?> selected <?php endif; ?>>All</option>
                        <?php $__currentLoopData = $providers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($provider->id); ?>" <?php if(isset($enrollment->section->provider_id) && $provider->id === $enrollment->section->provider_id): ?> selected <?php endif; ?>>
                                <?php echo e($provider->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['provider_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback" style="display: block !important;">
                            <?php echo e($errors->first('provider_id')); ?>

                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            <label for="term">Term*</label>
            <div class="form-row">
                <div class="col-md-2 mb-4">
                    <select name="term" id="term" class="form-select <?php $__errorArgs = ['term'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <option value="A" <?php if($term == 'A'): ?> selected <?php endif; ?>>All</option>
                        <option value="Y" <?php if($term == 'Y'): ?> selected <?php endif; ?>>Full Year</option>
                        <option value="F" <?php if($term == 'F'): ?> selected <?php endif; ?>>Fall</option>
                        <option value="S" <?php if($term == 'S'): ?> selected <?php endif; ?>>Spring</option>
                    </select>
                    <?php $__errorArgs = ['term'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback" style="display: block !important;">
                            <?php echo e($errors->first('term')); ?>

                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            <label for="student_id">Student*</label>
            <div class="form-row">
                <div class="col-md-4 mb-4">
                    <select name="student_id" id="student_id"
                        class="form-select <?php $__errorArgs = ['student_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($student->id); ?>" <?php if(isset($enrollment->student_id) && $student->id === $enrollment->student_id): ?> selected <?php endif; ?>>
                                <?php echo e($student->last_name . ', ' . $student->first_name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['student_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback" style="display: block !important;">
                            <?php echo e($errors->first('student_id')); ?>

                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <label for="section_id">Section*</label>
            <div class="form-row">
                <div class="col-md-8 mb-4" id="test">
                    <select name="section_id" id="section_id" class="form-select <?php $__errorArgs = ['section_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($section->id); ?>" <?php if(isset($enrollment) && $enrollment->section_id == $section->id): ?> selected <?php endif; ?>>
                                <?php echo e($section->provider->name); ?> - <?php echo e($section->course->name); ?> (<?php echo e($section->term == 'F' ? 'Fall' : ($section->term == 'S' ? 'Spring' : 'Full Year')); ?>) - <?php echo e($section->teacher->last_name); ?>, <?php echo e($section->teacher->first_name); ?> - <?php echo e($section->openSeats()); ?> open seats left
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['section_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback" style="display: block !important;">
                            <?php echo e($errors->first('section_id')); ?>

                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <?php echo $__env->make('admin.enrollments.show-hide-dual-credit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php if($action == 'edit'): ?>
                <?php if(auth()->user()->id == 1): ?>
                    <label for="lms_updated">LMS Updated?*</label>
                    <div class="form-row">
                        <div class="col-md-2 mb-4">
                            <select name="lms_updated" id="lms_updated"
                                class="form-select <?php $__errorArgs = ['lms_updated'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="0" <?php if(isset($enrollment->lms_updated) && 0 === $enrollment->lms_updated): ?> selected <?php endif; ?>>No</option>
                                <option value="1" <?php if(isset($enrollment->lms_updated) && 1 === $enrollment->lms_updated): ?> selected <?php endif; ?>>Yes</option>
                            </select>
                            <?php $__errorArgs = ['lms_updated'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback" style="display: block !important;">
                                    <?php echo e($errors->first('lms_updated')); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                <?php else: ?>
                    <input type="hidden" id="lms_updated" name="lms_updated" value="<?php echo e($enrollment->lms_updated); ?>" />
                <?php endif; ?>
                <label for="status">Status*</label>
                <div class="form-row">
                    <div class="col-md-2 mb-4">
                        <select name="status" id="status" class="form-select <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <option value="A" <?php if(isset($enrollment->status) && 'A' === $enrollment->status): ?> selected <?php endif; ?>>Approved</option>
                            <option value="R" <?php if(isset($enrollment->status) && 'R' === $enrollment->status): ?> selected <?php endif; ?>>Dropped</option>
                            <?php if(auth()->user()->role_id == 1): ?>
                                <option value="D" <?php if(isset($enrollment->status) && 'D' === $enrollment->status): ?> selected <?php endif; ?>>Denied</option>
                                <option value="W" <?php if(isset($enrollment->status) && 'W' === $enrollment->status): ?> selected <?php endif; ?>>Waitlist</option>
                            <?php endif; ?>
                        </select>
                        <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback" style="display: block !important;">
                                <?php echo e($errors->first('status')); ?>

                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <label for="ps_updated">PowerSchool Updated?*</label>
                <div class="form-row">
                    <div class="col-md-2 mb-4">
                        <select name="ps_updated" id="ps_updated"
                            class="form-select <?php $__errorArgs = ['ps_updated'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <option value="0" <?php if(isset($enrollment->ps_updated) && 0 === $enrollment->ps_updated): ?> selected <?php endif; ?>>No</option>
                            <option value="1" <?php if(isset($enrollment->ps_updated) && 1 === $enrollment->ps_updated): ?> selected <?php endif; ?>>Yes</option>
                        </select>
                        <?php $__errorArgs = ['ps_updated'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback" style="display: block !important;">
                                <?php echo e($errors->first('ps_updated')); ?>

                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            <?php endif; ?>
            <div class="form-row">
                <button type="submit" class="mt-4 btn btn-primary">Submit</button>
                <button type="button" class="mt-4 ml-4 btn btn-secondary"
                    onclick="window.history.go(-1); return false;">Cancel</button>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<!-- BEGIN PAGE SCRIPTS FILE -->
<?php $__env->startSection('page-js'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/js/selectize.min.js"
        integrity="sha512-IOebNkvA/HZjMM7MxL0NYeLYEalloZ8ckak+NDtOViP7oiYzG5vn6WVXyrJDiJPhl4yRdmNAG49iuLmhkUdVsQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/js/selectize.js"
        integrity="sha512-TCP0r/hsoR3XYFxxMqmxeCZSmHWkjdBiAGy+0xcQ+JU0hOBZMHho7O0x/bXZUf3DH6kcbGhuZFxONYXxMzd7EA=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        $(document).ready(function() {
            $('#student_id').selectize();
            $('#section_id').selectize({
                valueField: 'id',
                labelField: 'name',
                searchField: 'name',
                create: false
            });
            $("#jh").load('/admin/enrollments/show-hide-dual-credit/section/' + ($('#section_id').val() || ''));
        });

        $('#year_id').on('change', function(event) {
            $("#test").load('/admin/sections/sections-by-term/year/' + $('#year_id').val() + '/provider/' + $('#provider_id').val() + '/term/' + $('#term').val(), function() {
                $('#section_id').selectize();
            });
        });

        $('#provider_id').on('change', function(event) {
            $("#test").load('/admin/sections/sections-by-term/year/' + $('#year_id').val() + '/provider/' + $('#provider_id').val() + '/term/' + $('#term').val(), function() {
                $('#section_id').selectize();
            });
        });

        $('#term').on('change', function(event) {
            $("#test").load('/admin/sections/sections-by-term/year/' + $('#year_id').val() + '/provider/' + $('#provider_id').val() + '/term/' + $('#term').val(), function() {
                $('#section_id').selectize();
            });
        });

        $('#section_id').on('change', function(event) {
            $("#jh").load('/admin/enrollments/show-hide-dual-credit/section/' + $('#section_id').val());
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.cork', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/psjybwmy/public_html/registration/resources/views/admin/enrollments/form.blade.php ENDPATH**/ ?>