<?php $__env->startSection('title',  $title); ?>

<!-- BEGIN PAGE CSS -->
<?php $__env->startSection('page-css'); ?>
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
<?php $__env->stopSection(); ?>
<!-- END PAGE CSS -->


<!-- BEGIN BREADCRUMB -->
<?php $__env->startSection('breadcrumb'); ?>
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('schools.index')); ?>">Schools</a></li>
            <li class="breadcrumb-item active" aria-current="page"><?php echo e($title); ?></li>
        </ol>
    </nav>
</div>
<?php $__env->stopSection(); ?>
<!-- END BREADCRUMB -->
<?php $__env->startSection('content'); ?>
<h4><?php echo e($school->name); ?> </h4>
<?php if(isset($school->mailing_address)): ?>Mailing Address: <?php echo e($school->mailing_address); ?> <?php endif; ?> <?php if(isset($school->mailing_city)): ?><?php echo e($school->mailing_city); ?>,<?php endif; ?> <?php if(isset($school->mailing_state)): ?><?php echo e($school->mailing_state); ?><?php endif; ?> <?php if(isset($school->mailing_zip)): ?><?php echo e($school->mailing_zip); ?><?php endif; ?> <?php if(isset($school->mailing_zip4)): ?>-<?php echo e($school->mailing_zip4); ?><br/> <?php endif; ?>
<?php if(isset($school->site_address)): ?>Site Address: <?php echo e($school->site_address); ?> <?php endif; ?> <?php if(isset($school->site_city)): ?><?php echo e($school->site_city); ?>,<?php endif; ?> <?php if(isset($school->site_state)): ?><?php echo e($school->site_state); ?><?php endif; ?> <?php if(isset($school->site_zip)): ?><?php echo e($school->site_zip); ?> <br/> <?php endif; ?>
<?php if(isset($school->phone)): ?>Phone: <?php echo e(substr($school->phone, 0,  3)); ?>-<?php echo e(substr($school->phone, 3,  3)); ?>-<?php echo e(substr($school->phone, 6,  4)); ?> <?php if(empty($school->ext)): ?><br/><?php endif; ?> <?php endif; ?>  <?php if(isset($school->ext)): ?> Ext: <?php echo e($school->ext); ?> <br/> <?php endif; ?>
<?php if(isset($school->fax)): ?>Fax: <?php echo e(substr($school->fax, 0,  3)); ?>-<?php echo e(substr($school->fax, 3,  3)); ?>-<?php echo e(substr($school->fax, 6,  4)); ?> <?php if(empty($school->fax_ext)): ?><br/><?php endif; ?> <?php endif; ?>  <?php if(isset($school->fax_ext)): ?> Ext: <?php echo e($school->fax_ext); ?> <br/> <?php endif; ?>
<?php if(isset($school->website)): ?>Website: <a href="<?php echo e($school->website); ?>" target="_blank"><?php echo e($school->website); ?></a><br/> <?php endif; ?>
<?php if(isset($school->notes)): ?>Notes: <?php echo e($school->notes); ?> <br/> <?php endif; ?>
</div>

<!-- List Students -->
<?php if($students->isEmpty()): ?>
<h4>No Students Found</h4>
<?php else: ?>
<h4><?php echo e($students->count()); ?> Students</h4>
<div class="table-responsive">
<table class="table table-bordered table-hover mb-4">
    <thead>
    <tr>
        <th>Name</th>
        <th>Grade</th>
        <th>Email</th>
        <th></th>
    </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr style="background-color:#DCDCDC;">
            <td><strong><?php echo e($s->first_name); ?> <?php echo e($s->last_name); ?></strong></td>
            <td><strong><?php echo e($s->grade); ?></strong></td>
            <td><strong><?php echo e($s->email); ?></strong></td>
            <td>
                <a href="<?php echo e(route('students.show', $s->id)); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 576 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M288 32c-80.8 0-145.5 36.8-192.6 80.6C48.6 156 17.3 208 2.5 243.7c-3.3 7.9-3.3 16.7 0 24.6C17.3 304 48.6 356 95.4 399.4C142.5 443.2 207.2 480 288 480s145.5-36.8 192.6-80.6c46.8-43.5 78.1-95.4 93-131.1c3.3-7.9 3.3-16.7 0-24.6c-14.9-35.7-46.2-87.7-93-131.1C433.5 68.8 368.8 32 288 32zM144 256a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-64c0 35.3-28.7 64-64 64c-7.1 0-13.9-1.2-20.3-3.3c-5.5-1.8-11.9 1.6-11.7 7.4c.3 6.9 1.3 13.8 3.2 20.7c13.7 51.2 66.4 81.6 117.6 67.9s81.6-66.4 67.9-117.6c-11.1-41.5-47.8-69.4-88.6-71.1c-5.8-.2-9.2 6.1-7.4 11.7c2.1 6.4 3.3 13.2 3.3 20.3z"/></svg></a>&nbsp;
                <a href="<?php echo e(route('students.edit', $s->id)); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M362.7 19.3L314.3 67.7 444.3 197.7l48.4-48.4c25-25 25-65.5 0-90.5L453.3 19.3c-25-25-65.5-25-90.5 0zm-71 71L58.6 323.5c-10.4 10.4-18 23.3-22.2 37.4L1 481.2C-1.5 489.7 .8 498.8 7 505s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L421.7 220.3 291.7 90.3z"/></svg></a>&nbsp;
                <a href="<?php echo e(route('students.delete', $s->id)); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M135.2 17.7L128 32H32C14.3 32 0 46.3 0 64S14.3 96 32 96H416c17.7 0 32-14.3 32-32s-14.3-32-32-32H320l-7.2-14.3C307.4 6.8 296.3 0 284.2 0H163.8c-12.1 0-23.2 6.8-28.6 17.7zM416 128H32L53.2 467c1.6 25.3 22.6 45 47.9 45H346.9c25.3 0 46.3-19.7 47.9-45L416 128z"/></svg></a>
            </td>
        </tr>
        <?php $__currentLoopData = $s->enrollments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td colspan="3"><?php echo e($e->course->name); ?></td>
            <td>

            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr><td colspan="4">&nbsp;</td></tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
</div>
<?php endif; ?>
<p class="mt-2">
<button class="btn btn-warning mb-2" onclick="window.location.href = '<?php echo e(route("schools.edit", $school->id)); ?>';">Edit School</button> <button class="btn btn-danger mb-2" onclick="window.location.href = '<?php echo e(route("schools.delete", $school->id)); ?>';">Delete School</button>
</p>
<?php $__env->stopSection(); ?>
<!--  BEGIN PAGE SCRIPTS FILE  -->
<?php $__env->startSection('page-js'); ?>

<?php $__env->stopSection(); ?>
<!--  END PAGE SCRIPTS FILE  -->

<?php echo $__env->make('layouts.cork', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\jason_horner\Dropbox\laravel\10\registration\resources\views/admin/schools/show.blade.php ENDPATH**/ ?>