<?php $__env->startSection('title', $title); ?>

<!-- BEGIN PAGE CSS -->
<?php $__env->startSection('page-css'); ?>
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }
    </style>
<?php $__env->stopSection(); ?>
<!-- END PAGE CSS -->


<!-- BEGIN BREADCRUMB -->
<?php $__env->startSection('breadcrumb'); ?>
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('enrollments.index')); ?>">Enrollments</a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e($title); ?></li>
            </ol>
        </nav>
    </div>
<?php $__env->stopSection(); ?>
<!-- END BREADCRUMB -->
<?php $__env->startSection('content'); ?>
    <a href="<?php echo e(route('students.show', $enrollment->student->id)); ?>" style="color: blue; text-decoration: underline;">
        <?php echo e($enrollment->student->first_name . ' ' . $enrollment->student->last_name); ?>

    </a><br />
    <a href="mailto:<?php echo e($enrollment->student->email); ?>" style="color: blue; text-decoration: underline;"><?php echo e($enrollment->student->email); ?></a><br />
    Section: <?php echo e($enrollment->year->year); ?> <?php echo e($enrollment->section->course->name); ?><br />

    <?php if(isset($enrollment->phone)): ?>
        <?php echo e(substr($enrollment->phone, 0, 3)); ?>-<?php echo e(substr($enrollment->phone, 3, 3)); ?>-<?php echo e(substr($enrollment->phone, 6, 4)); ?>

        <?php endif; ?> <?php if(isset($enrollment->ext)): ?>
            Ext: <?php echo e($enrollment->ext); ?>

        <?php endif; ?>
        <h4 class="mt-2">Teacher Information</h4>
        <p class="mt-1"><?php echo e($enrollment->section->teacher->first_name); ?> <?php echo e($enrollment->section->teacher->last_name); ?><br />
            <a href="mailto:<?php echo e($enrollment->section->teacher->email); ?>" style="color: blue; text-decoration: underline;"><?php echo e($enrollment->section->teacher->email); ?></a><br />
            <?php if(isset($enrollment->section->teacher->phone)): ?><?php echo e($enrollment->section->teacher->formattedPhone()); ?> <?php endif; ?>
        </p><br/>
        <p class="mt-2">
            <?php if(auth()->user()->role_id == 1): ?>
                <button class="btn btn-warning mb-2"
                    onclick="window.location.href = '<?php echo e(route('enrollments.edit', $enrollment->id)); ?>';">Edit
                    Enrollment</button>
                <button class="btn btn-danger mb-2"
                    onclick="window.location.href = '<?php echo e(route('enrollments.delete', $enrollment->id)); ?>';">Delete
                    Enrollment</button>
            <?php else: ?>
                <?php if($enrollment->status != 'R'): ?>
                    <button class="btn btn-danger mb-2"
                        onclick="window.location.href = '<?php echo e(route('enrollments.drop', $enrollment->id)); ?>';">Drop
                        Enrollment</button>
                <?php endif; ?>
            <?php endif; ?>
        </p>
    <?php $__env->stopSection(); ?>
    <!--  BEGIN PAGE SCRIPTS FILE  -->
    <?php $__env->startSection('page-js'); ?>

    <?php $__env->stopSection(); ?>
    <!--  END PAGE SCRIPTS FILE  -->

<?php echo $__env->make('layouts.cork', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/psjybwmy/public_html/registration/resources/views/admin/enrollments/show.blade.php ENDPATH**/ ?>