<?php $__env->startSection('title', $title); ?>

<!-- BEGIN PAGE CSS -->
<?php $__env->startSection('page-css'); ?>
    <link href="/cork/src/plugins/src/apex/apexcharts.css" rel="stylesheet" type="text/css">
    <link href="/cork/src/assets/css/light/components/list-group.css" rel="stylesheet" type="text/css">
    <link href="/cork/src/assets/css/light/dashboard/dash_2.css" rel="stylesheet" type="text/css" />
    <link href="/cork/src/assets/css/dark/components/list-group.css" rel="stylesheet" type="text/css">
    <link href="/cork/src/assets/css/dark/dashboard/dash_2.css" rel="stylesheet" type="text/css" />
<?php $__env->stopSection(); ?>
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
<?php $__env->startSection('breadcrumb'); ?>
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Schools</li>
            </ol>
        </nav>
    </div>
    <!-- /BREADCRUMB -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="layout-px-spacing">

        <div class="middle-content container-xxl p-0">

            <div class="row layout-top-spacing">

                <div class="col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12 layout-spacing">
                    <div class="widget widget-chart-two">
                        <div class="widget-heading">
                            <h5 class="">Total Enrollments</h5>
                        </div>
                        <div class="widget-content">
                            <div id="total-enrollments" class=""></div>
                        </div>
                    </div>
                </div>
                <?php if(auth()->user()->role_id == 1 || auth()->user()->role_id == 2): ?>
                    <?php if($totalCancelledSectionEnrollments > 0): ?>
                        <div class="col-xl-6 col-lg-12 col-md-12 col-sm-12 col-12 layout-spacing">
                            <div class="widget widget-table-two">

                                <div class="widget-heading">
                                    <h5 class="">Cancelled Section Enrollments (<?php if($totalCancelledSectionEnrollments > 4): ?>
                                            4 of
                                        <?php endif; ?><?php echo e($totalCancelledSectionEnrollments); ?>)</h5>
                                </div>

                                <div class="widget-content">
                                    <div class="table-responsive">
                                        <?php if($totalCancelledSectionEnrollments > 0): ?>
                                            <table class="table">
                                                <thead>
                                                    <tr>
                                                        <th>Student</th>
                                                        <th>Enrollment</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__currentLoopData = $cancelledSectionEnrollments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><?php echo e(App\Models\Student::find($c->student_id)->last_name); ?>,
                                                                <?php echo e(App\Models\Student::find($c->student_id)->first_name); ?>

                                                            </td>
                                                            <td><?php echo e(App\Models\Course::find(App\Models\Section::find($c->section_id)->course_id)->name); ?>

                                                            </td>
                                                            <td><a
                                                                    href="<?php echo e(route('enrollments.show', App\Models\Enrollment::find($c->id)->id)); ?>">View</a>
                                                                | <a
                                                                    href="<?php echo e(route('enrollments.edit', App\Models\Enrollment::find($c->id)->id)); ?>">Edit</a>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        <?php else: ?>
                                            <h5><img src="/cork/src/assets/img/green-checkmark.png" width="35"
                                                    height="35" style="text-align: left; padding:5px">Nice! No cancelled
                                                section enrollments!</h5>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($waitListEnrollmentsReadyToAdd->count() > 0): ?>
                        <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12 layout-spacing">
                            <div class="widget widget-table-one">
                                <div class="widget-heading">
                                    <h5 class="">Waitlist Enrollments With Open Seats</h5>
                                </div>
                                <?php $__currentLoopData = $waitListEnrollmentsReadyToAdd; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $w): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        if (App\Models\Section::find($w->section_id)->openSeats() <= 0) {
                                            continue;
                                        }
                                    ?>
                                    <div class="widget-content">
                                        <div class="transactions-list t-info">
                                            <div class="t-item">
                                                <div class="t-company-name">
                                                    <div class="t-icon">
                                                        <div class="avatar">
                                                            <span
                                                                class="avatar-title"><?php echo e(substr(App\Models\Student::find($w->student_id)->last_name, 0, 1)); ?><?php echo e(substr(App\Models\Student::find($w->student_id)->first_name, 0, 1)); ?></span>
                                                        </div>
                                                    </div>
                                                    <div class="t-name">
                                                        <h4>
                                                            <?php echo e(App\Models\Student::find($w->student_id)->last_name); ?>,
                                                            <?php echo e(App\Models\Student::find($w->student_id)->first_name); ?></h4>
                                                        <p class="meta-date">
                                                            <?php echo e(substr(App\Models\Section::find($w->section_id)->course->name, 0, 35)); ?>

                                                        </p>
                                                    </div>
                                                </div>
                                                <div class="t-rate rate-inc">
                                                    <p><span><a href="<?php echo e(route('enrollments.show', $w->id)); ?>">View</a> |
                                                            <a
                                                                href="<?php echo e(route('enrollments.edit', $w->id)); ?>">Edit</a></span>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>

        </div>

    </div>
<?php $__env->stopSection(); ?>
<!--  BEGIN PAGE SCRIPTS FILE  -->
<?php $__env->startSection('page-js'); ?>
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script>
        var options = {
            series: [
                <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($d->totalEnrollments); ?>,
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ],
            labels: [
                <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    '<?php echo e($d->code); ?>',
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ],
            chart: {
                type: 'donut',
            },
            colors: [
                <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    '<?php echo e($d->color); ?>',
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ],
            plotOptions: {
                pie: {
                    startAngle: 0,
                    endAngle: 360,
                    expandOnClick: true,
                    offsetX: 0,
                    offsetY: 0,
                    customScale: 1,
                    dataLabels: {
                        offset: 0,
                        minAngleToShowLabel: 10
                    },
                    donut: {
                        size: '65%',
                        background: 'transparent',
                        labels: {
                            show: true,
                            name: {
                                show: true,
                                fontSize: '22px',
                                fontFamily: 'Helvetica, Arial, sans-serif',
                                fontWeight: 600,
                                color: undefined,
                                offsetY: -10,
                                formatter: function(val) {
                                    return val
                                }
                            },
                            value: {
                                show: true,
                                fontSize: '16px',
                                fontFamily: 'Helvetica, Arial, sans-serif',
                                fontWeight: 400,
                                color: undefined,
                                offsetY: 16,
                                formatter: function(val) {
                                    return val
                                }
                            },
                            total: {
                                show: true,
                                showAlways: true,
                                label: 'Total',
                                fontSize: '22px',
                                fontFamily: 'Helvetica, Arial, sans-serif',
                                fontWeight: 600,
                                color: '#373d3f',
                                formatter: function(w) {
                                    return w.globals.seriesTotals.reduce((a, b) => {
                                        return a + b
                                    }, 0)
                                }
                            }
                        }
                    },
                }
            },
            responsive: [{
                breakpoint: 480,
                options: {
                    chart: {
                        width: 200
                    },
                    legend: {
                        show: true,
                        position: 'bottom'
                    }
                }
            }]
        };

        var chart = new ApexCharts(document.querySelector("#total-enrollments"), options);
        chart.render();
    </script>
<?php $__env->stopSection(); ?>
<!--  END PAGE SCRIPTS FILE  -->

<?php echo $__env->make('layouts.cork', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/psjybwmy/public_html/registration/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>