<div class="widget">
    <div class="widget-heading">
        <h5 class="text-center">Students Without SSID</h5>
    </div>
    <div class="widget-content">
        <div class="dashboard-card">
            <?php if($studentsWithoutSSID->count() > 0): ?>
                <div class="dashboard-number text-center">
                    <?php echo e($studentsWithoutSSID->count()); ?>

                    <div class="view-details-link">
                        <a href="<?php echo e(route('students.needs_ssid')); ?>" class="blue-underline-link">View Details</a>
                    </div>
                </div>
            <?php else: ?>
                <h5 class="text-center">
                    <img src="/cork/src/assets/img/green-checkmark.png" class="green-checkmark" alt="Checkmark">
                    All students have valid SSIDs!
                </h5>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
    .widget-heading h5 {
        margin-bottom: 15px;
    }
    .dashboard-card {
        display: flex;
        justify-content: center;
        align-items: center;
        min-height: 100px;
    }
    .dashboard-number {
        font-size: 2.5rem;
        font-weight: bold;
        display: flex;
        flex-direction: column;
        align-items: center;
    }
    .green-checkmark {
        width: 24px;
        height: 24px;
        vertical-align: middle;
        margin-right: 10px;
    }
    .view-details-link {
        margin-top: 10px;
        font-size: medium;
    }
    .blue-underline-link {
        color: blue;
        text-decoration: underline;
    }
</style>
<?php /**PATH /home/psjybwmy/public_html/registration/resources/views/admin/partials/dashboard/students_without_ssid.blade.php ENDPATH**/ ?>