<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('page-css'); ?>
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }

        .table-container {
            margin-bottom: 20px;
        }

        .warning-banner {
            background-color: #fff3cd;
            border: 1px solid #ffeeba;
            color: #856404;
            padding: 12px;
            margin-bottom: 20px;
            border-radius: 4px;
            font-weight: bold;
        }

        .facilitator-list {
            list-style-type: none;
            padding-left: 0;
        }

        .facilitator-item {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
        }

        .facilitator-name {
            margin-right: 10px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <form method="post" action="<?php echo e(route('welcome-letters.bulk-send-confirm', $welcomeLetter->id)); ?>"
        enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

        <div class="table-container">
            <h3>Students</h3>
            <table id="students-table" class="table dt-table-hover" style="width:100%">
                <thead>
                    <tr>
                        <th><input type="checkbox" id="select-all-students"></th>
                        <th>Name</th>
                        <th>School</th>
                        <th>Email</th>
                        <th>Sent?</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $enrollments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><input type="checkbox" name="enrollments[]" value="<?php echo e($e->id); ?>"></td>
                            <td><?php echo e($e->student->first_name); ?> <?php echo e($e->student->last_name); ?></td>
                            <td><?php echo e($e->student->school->name); ?></td>
                            <td><?php echo e($e->student->email); ?></td>
                            <td>
                                <?php if($e->sent_welcome_letter): ?>
                                    <span class="badge badge-success">Yes</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">No</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <div class="warning-banner">
            ⚠️ Warning: Facilitator bulk send functionality is currently in testing. Please use with caution.
        </div>

        <div class="table-container">
            <h3>Facilitators</h3>
            <table id="facilitators-table" class="table dt-table-hover" style="width:100%">
                <thead>
                    <tr>
                        <th><input type="checkbox" id="select-all-facilitators"></th>
                        <th>School</th>
                        <th>Facilitators</th>
                        <th>Sent?</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        $groupedFacilitators = $facilitators->groupBy('school_name');
                    ?>
                    <?php $__currentLoopData = $groupedFacilitators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schoolName => $schoolFacilitators): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                
                                <?php $__currentLoopData = $schoolFacilitators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="checkbox" name="facilitators[]" value="<?php echo e($f->id); ?>" class="school-checkbox" style="display: none;">
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                                <input type="checkbox" class="school-checkbox-visible">
                            </td>
                            <td><?php echo e($schoolName); ?></td>
                            <td>
                                <ul class="facilitator-list">
                                    <?php $__currentLoopData = $schoolFacilitators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="facilitator-item">
                                            <span class="facilitator-name">
                                                <?php echo e($f->first_name); ?> <?php echo e($f->last_name); ?>

                                            </span>
                                            <span class="facilitator-email"><?php echo e($f->email); ?></span>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </td>
                            <td>
                                <?php if($schoolFacilitators->first()->sent_copy): ?>
                                    <span class="badge badge-success">Yes</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">No</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <div class="form-row">
            <button type="submit" class="btn btn-primary">Send Emails</button>
            <button type="button" class="btn btn-secondary ml-2"
                onclick="window.history.go(-1); return false;">Cancel</button>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-js'); ?>
    <script>
$(document).ready(function() {
    // Handle select all students
    $('#select-all-students').on('change', function() {
        var isChecked = $(this).prop('checked');
        $('input[name="enrollments[]"]').prop('checked', isChecked);
    });

    // Update select all checkbox when individual students are checked/unchecked
    $('input[name="enrollments[]"]').on('change', function() {
        var allChecked = $('input[name="enrollments[]"]').length === $('input[name="enrollments[]"]:checked').length;
        $('#select-all-students').prop('checked', allChecked);
    });

    // Handle select all facilitators
    $('#select-all-facilitators').on('change', function() {
        var isChecked = $(this).prop('checked');
        $('.school-checkbox-visible').prop('checked', isChecked).trigger('change');
    });

    // When visible school checkbox is clicked
    $('.school-checkbox-visible').on('change', function() {
        var isChecked = $(this).prop('checked');
        // Find all hidden facilitator checkboxes in this row
        $(this).closest('td').find('input[name="facilitators[]"]').prop('checked', isChecked);
        
        // Update select all checkbox
        var allChecked = $('.school-checkbox-visible:checked').length === $('.school-checkbox-visible').length;
        $('#select-all-facilitators').prop('checked', allChecked);
    });
});
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.cork', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/psjybwmy/public_html/registration/resources/views/admin/welcome-letters/bulk-send.blade.php ENDPATH**/ ?>