<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Contact <?php echo e($action); ?> Notification</title>
</head>
<body style="font-family: Arial, sans-serif; line-height: 1.6; color: #333;">
    <h2>Contact <?php echo e($action); ?> Notification</h2>
    <p>A contact has been <?php echo e(strtolower($action)); ?> in the system. Below are the details:</p>

    <h3>Contact Information</h3>
    <p><strong>Name:</strong> <?php echo e($contact->first_name); ?> <?php echo e($contact->last_name); ?></p>
    <p><strong>School:</strong> <?php echo e($schoolName); ?></p>

    <h3>Affected Sections and Students</h3>
    <?php if(!empty($sections)): ?>
        <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <h4>Section: <?php echo e($section['name']); ?></h4>
            <ul>
                <?php $__currentLoopData = $section['students']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($student->first_name); ?> <?php echo e($student->last_name); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <p>No relevant sections or students found.</p>
    <?php endif; ?>

    <p>If you have any questions, please contact the system administrator.</p>
    <p>Thank you,</p>
    <p>BASC Team</p>
</body>
</html><?php /**PATH /home/psjybwmy/public_html/registration/resources/views/emails/contact_changed.blade.php ENDPATH**/ ?>