<?php $__env->startSection('title', 'Upload BPS Medical Terminology Students'); ?>

<?php $__env->startSection('page-css'); ?>
    <style>
        .form-group { margin-bottom: 1.5rem; }
        .invalid-feedback { display: block !important; }
        .csv-notes ul { list-style-type: disc; margin-left: 20px; }
        .csv-notes li { margin-bottom: 5px; }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('enrollments.index')); ?>">Enrollments</a></li>
                <li class="breadcrumb-item active" aria-current="page">Upload BPS Medical Terminology</li>
            </ol>
        </nav>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <?php if($message = Session::get('error')): ?>
            <div class="alert alert-danger alert-dismissible" role="alert">
                <h6 class="alert-heading mb-1"><i class="bx bx-xs bx-store align-top me-2"></i>Error!</h6>
                <span><?php echo e($message); ?></span>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title">CSV File Requirements</h5>
            </div>
            <div class="card-body csv-notes">
                <p>For a successful upload, your <a style="color:blue; text-decoration:underline" href="https://docs.google.com/spreadsheets/d/1KoR0xCcEXMXdOBTIVJK2Dm_0QlK2WRCUh6MA6XTIqTo/edit?usp=sharing" target="_blank">CSV file</a> must contain the following columns with their specific value requirements:</p>
                <ul>
                    <li><strong>`first_name`</strong>: Required. String, maximum 50 characters.</li>
                    <li><strong>`last_name`</strong>: Required. String, maximum 50 characters.</li>
                    <li><strong>`school_id`</strong>: Required. Integer. Must be one of the following values:
                        <ul>
                            <li>`5` (for CHS)</li>
                            <li>`6` (for BHS)</li>
                            <li>`8` (for LHS)</li>
                        </ul>
                    </li>
                    <li><strong>`email`</strong>: Required. Valid email format, maximum 75 characters.</li>
                    <li><strong>`dob`</strong>: Required. Date format (e.g., `YYYY-MM-DD`).</li>
                    <li><strong>`phone`</strong>: Optional. String, maximum 10 characters (digits only).</li>
                    <li><strong>`grade`</strong>: Required. Integer, between 9 and 12.</li>
                    <li><strong>`gender`</strong>: Required. Must be `M` (Male) or `F` (Female).</li>
                    <li><strong>`ssid`</strong>: Required. Integer (Student State ID).</li>
                    <li><strong>`iep`</strong>: Required. Boolean. Use `0` for false, `1` for true.</li>
                    <li><strong>`has_504`</strong>: Required. Boolean. Use `0` for false, `1` for true.</li>
                    <li><strong>`english_learner`</strong>: Required. Boolean. Use `0` for false, `1` for true.</li>
                    <li><strong>`term`</strong>: Required. String. Must be `F` (Fall) or `S` (Spring).</li>
                    <li><strong>`notes`</strong>: Optional. Any text notes.</li>
                </ul>
            </div>
        </div>

        <form action="<?php echo e(route('enrollments.bps-medterm-upload-preview')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php $__currentLoopData = $dropdowns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $sections): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="form-group">
                    <label for="<?php echo e(str_replace(' ', '_', strtolower($label))); ?>"><?php echo e($label); ?></label>
                    <select name="<?php echo e(str_replace(' ', '_', strtolower($label))); ?>" id="<?php echo e(str_replace(' ', '_', strtolower($label))); ?>" class="form-select <?php $__errorArgs = [str_replace(' ', '_', strtolower($label))];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <option value="">-- Select <?php echo e($label); ?> Section --</option>
                        <?php if($sections->isNotEmpty()): ?>
                            <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <option value="" disabled>No sections available</option>
                        <?php endif; ?>
                    </select>
                    <?php $__errorArgs = [str_replace(' ', '_', strtolower($label))];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <div class="form-group">
                <label for="csv_file">Upload CSV File</label>
                <input type="file" name="csv_file" id="csv_file" class="form-control <?php $__errorArgs = ['csv_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" accept=".csv,.txt">
                <?php $__errorArgs = ['csv_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <button type="submit" class="btn btn-primary">Preview</button>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.cork', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/psjybwmy/public_html/registration/resources/views/admin/enrollments/bps-medterm-upload.blade.php ENDPATH**/ ?>