<?php $__env->startSection('title', 'BPS Medical Terminology Upload Summary'); ?>

<?php $__env->startSection('page-css'); ?>
    <style>
        .table-responsive { overflow-x: auto; }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('enrollments.index')); ?>">Enrollments</a></li>
                <li class="breadcrumb-item active" aria-current="page">Upload Summary</li>
            </ol>
        </nav>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <h1>Upload Summary</h1>
        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible" role="alert">
                <h6 class="alert-heading mb-1"><i class="bx bx-xs bx-store align-top me-2"></i>Errors!</h6>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <span><?php echo e($error); ?></span><br>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
        <h3>New Students Created</h3>
        <?php if($createdStudents): ?>
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>School</th>
                            <th>Section</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $createdStudents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($student['id']); ?></td>
                                <td><?php echo e($student['name']); ?></td>
                                <td><?php echo e($student['school']); ?></td>
                                <td><?php echo e($student['section']); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p>No new students created.</p>
        <?php endif; ?>

        <h3>Existing Students Enrolled</h3>
        <?php if($existingStudents): ?>
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>School</th>
                            <th>Section</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $existingStudents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($student['id']); ?></td>
                                <td><?php echo e($student['name']); ?></td>
                                <td><?php echo e($student['school']); ?></td>
                                <td><?php echo e($student['section']); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p>No existing students enrolled.</p>
        <?php endif; ?>

        <a href="<?php echo e(route('enrollments.index')); ?>" class="btn btn-primary">Back to Enrollments</a>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.cork', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/psjybwmy/public_html/registration/resources/views/admin/enrollments/bps-medterm-upload-summary.blade.php ENDPATH**/ ?>